/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SystemSessionPropertiesProvider;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.server.protocol.spooling.SpoolingConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.function.Consumer;

public class SpoolingSessionProperties
implements SystemSessionPropertiesProvider {
    public static final String INITIAL_SEGMENT_SIZE = "spooling_initial_segment_size";
    public static final String MAX_SEGMENT_SIZE = "spooling_max_segment_size";
    public static final String INLINING_ENABLED = "spooling_inlining_enabled";
    public static final String INLINING_MAX_SIZE = "spooling_inlining_max_size";
    public static final String INLINING_MAX_ROWS = "spooling_inlining_max_rows";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public SpoolingSessionProperties(SpoolingConfig spoolingConfig) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadataUtil.dataSizeProperty((String)INITIAL_SEGMENT_SIZE, (String)"Initial size of a spooled segment", (DataSize)spoolingConfig.getInitialSegmentSize(), this.isDataSizeBetween(INITIAL_SEGMENT_SIZE, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)MAX_SEGMENT_SIZE, (String)"Maximum size of a spooled segment", (DataSize)spoolingConfig.getMaximumSegmentSize(), this.isDataSizeBetween(MAX_SEGMENT_SIZE, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)INLINING_ENABLED, (String)"Allow inlining initial rows", (Boolean)spoolingConfig.isInliningEnabled(), (boolean)false)).add((Object)PropertyMetadataUtil.dataSizeProperty((String)INLINING_MAX_SIZE, (String)"Maximum size of inlined data", (DataSize)spoolingConfig.getInliningMaxSize(), this.isDataSizeBetween(INLINING_MAX_SIZE, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), (boolean)false)).add((Object)PropertyMetadata.longProperty((String)INLINING_MAX_ROWS, (String)"Maximum number of rows that are allowed to be inlined per worker", (Long)spoolingConfig.getInliningMaxRows(), (boolean)false)).build();
    }

    private Consumer<DataSize> isDataSizeBetween(String property, DataSize min, DataSize max) {
        return value -> {
            if (min.compareTo(value) > 0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property '" + property + "' must be greater than " + String.valueOf(min));
            }
            if (max.compareTo(value) < 0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Session property '" + property + "' must be smaller than " + String.valueOf(max));
            }
        };
    }

    public static DataSize getInitialSegmentSize(Session session) {
        return session.getSystemProperty(INITIAL_SEGMENT_SIZE, DataSize.class);
    }

    public static DataSize getMaxSegmentSize(Session session) {
        return session.getSystemProperty(MAX_SEGMENT_SIZE, DataSize.class);
    }

    public static boolean isInliningEnabled(Session session) {
        return session.getSystemProperty(INLINING_ENABLED, Boolean.class);
    }

    public static DataSize getInliningMaxSize(Session session) {
        return session.getSystemProperty(INLINING_MAX_SIZE, DataSize.class);
    }

    public static long getInliningMaxRows(Session session) {
        return session.getSystemProperty(INLINING_MAX_ROWS, Long.class);
    }

    @Override
    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }
}

