/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientBinder;
import io.jsonwebtoken.Locator;
import io.trino.server.security.jwt.FileSigningKeyLocator;
import io.trino.server.security.jwt.ForJwt;
import io.trino.server.security.jwt.JwkService;
import io.trino.server.security.jwt.JwkSigningKeyLocator;
import io.trino.server.security.jwt.JwtAuthenticatorConfig;
import java.net.URI;
import java.security.Key;

public class JwtAuthenticatorSupportModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(JwtAuthenticatorConfig.class);
        this.install(ConditionalModule.conditionalModule(JwtAuthenticatorConfig.class, JwtAuthenticatorSupportModule::isHttp, (Module)new JwkModule(), jwkBinder -> jwkBinder.bind((TypeLiteral)new TypeLiteral<Locator<Key>>(this){}).annotatedWith(ForJwt.class).to(FileSigningKeyLocator.class).in(Scopes.SINGLETON)));
    }

    private static boolean isHttp(JwtAuthenticatorConfig config) {
        return config.getKeyFile().startsWith("https://") || config.getKeyFile().startsWith("http://");
    }

    private static class JwkModule
    implements Module {
        private JwkModule() {
        }

        public void configure(Binder binder) {
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("jwk", ForJwt.class);
        }

        @Provides
        @Singleton
        @ForJwt
        public static JwkService createJwkService(JwtAuthenticatorConfig config, @ForJwt HttpClient httpClient) {
            return new JwkService(URI.create(config.getKeyFile()), httpClient);
        }

        @Provides
        @Singleton
        @ForJwt
        public static Locator<Key> createJwkSigningKeyLocator(@ForJwt JwkService jwkService) {
            return new JwkSigningKeyLocator(jwkService);
        }

        public int hashCode() {
            return JwkModule.class.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof JwkModule;
        }
    }
}

