/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryPreparer;
import io.trino.execution.SessionPropertyEvaluator;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.SessionProperty;
import io.trino.sql.tree.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class SessionPropertyResolver {
    private final SessionPropertyEvaluator sessionPropertyEvaluator;
    private final AccessControl accessControl;

    @Inject
    public SessionPropertyResolver(SessionPropertyEvaluator sessionPropertyEvaluator, AccessControl accessControl) {
        this.sessionPropertyEvaluator = Objects.requireNonNull(sessionPropertyEvaluator, "sessionEvaluator is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SessionPropertiesApplier getSessionPropertiesApplier(QueryPreparer.PreparedQuery preparedQuery) {
        Statement statement = preparedQuery.getStatement();
        if (!(statement instanceof Query)) {
            return session -> session;
        }
        Query queryStatement = (Query)statement;
        return session -> this.prepareSession((Session)session, queryStatement.getSessionProperties(), ParameterExtractor.bindParameters(preparedQuery.getStatement(), preparedQuery.getParameters()));
    }

    private Session prepareSession(Session session, List<SessionProperty> sessionProperties, Map<NodeRef<Parameter>, Expression> parameters) {
        ResolvedSessionProperties resolvedSessionProperties = this.resolve(session, parameters, sessionProperties);
        return this.overrideProperties(session, resolvedSessionProperties);
    }

    private ResolvedSessionProperties resolve(Session session, Map<NodeRef<Parameter>, Expression> parameters, List<SessionProperty> sessionProperties) {
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        HashBasedTable catalogProperties = HashBasedTable.create();
        HashSet<QualifiedName> seenPropertyNames = new HashSet<QualifiedName>();
        for (SessionProperty sessionProperty : sessionProperties) {
            List nameParts = sessionProperty.getName().getParts();
            if (!seenPropertyNames.add(sessionProperty.getName())) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)sessionProperty, "Session property '%s' already set", sessionProperty.getName());
            }
            if (nameParts.size() == 1) {
                systemProperties.put((Object)((String)nameParts.getFirst()), (Object)this.sessionPropertyEvaluator.evaluate(session, sessionProperty.getName(), sessionProperty.getValue(), parameters));
                continue;
            }
            if (nameParts.size() == 2) {
                String catalogName = (String)nameParts.getFirst();
                String propertyName = (String)nameParts.getLast();
                catalogProperties.put((Object)catalogName, (Object)propertyName, (Object)this.sessionPropertyEvaluator.evaluate(session, sessionProperty.getName(), sessionProperty.getValue(), parameters));
                continue;
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)sessionProperty, "Invalid session property '%s'", sessionProperty.getName());
        }
        return new ResolvedSessionProperties((Map<String, String>)systemProperties.buildOrThrow(), catalogProperties.rowMap());
    }

    private Session overrideProperties(Session session, ResolvedSessionProperties resolvedSessionProperties) {
        Objects.requireNonNull(resolvedSessionProperties, "resolvedSessionProperties is null");
        this.validateSystemProperties(session, resolvedSessionProperties.systemProperties());
        if (session.getTransactionId().isPresent()) {
            this.validateCatalogProperties(session, resolvedSessionProperties.catalogProperties());
        }
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        systemProperties.putAll(session.getSystemProperties());
        systemProperties.putAll(resolvedSessionProperties.systemProperties());
        HashMap<String, Map<String, String>> catalogProperties = new HashMap<String, Map<String, String>>(session.getCatalogProperties());
        for (Map.Entry<String, Map<String, String>> catalogEntry : resolvedSessionProperties.catalogProperties().entrySet()) {
            catalogProperties.computeIfAbsent(catalogEntry.getKey(), string -> new HashMap()).putAll(catalogEntry.getValue());
        }
        return session.withProperties(systemProperties, catalogProperties);
    }

    private void validateSystemProperties(Session session, Map<String, String> systemProperties) {
        for (Map.Entry<String, String> property : systemProperties.entrySet()) {
            this.accessControl.checkCanSetSystemSessionProperty(session.getIdentity(), session.getQueryId(), property.getKey());
        }
    }

    private void validateCatalogProperties(Session session, Map<String, Map<String, String>> catalogsProperties) {
        Preconditions.checkState((boolean)session.getTransactionId().isPresent(), (Object)"Not in transaction");
        for (Map.Entry<String, Map<String, String>> catalogProperties : catalogsProperties.entrySet()) {
            for (Map.Entry<String, String> catalogProperty : catalogProperties.getValue().entrySet()) {
                this.accessControl.checkCanSetCatalogSessionProperty(new SecurityContext(session.getRequiredTransactionId(), session.getIdentity(), session.getQueryId(), session.getStart()), catalogProperties.getKey(), catalogProperty.getKey());
            }
        }
    }

    @FunctionalInterface
    public static interface SessionPropertiesApplier
    extends Function<Session, Session> {
    }

    public record ResolvedSessionProperties(Map<String, String> systemProperties, Map<String, Map<String, String>> catalogProperties) {
        public ResolvedSessionProperties {
            systemProperties = ImmutableMap.copyOf(Objects.requireNonNull(systemProperties, "systemProperties is null"));
            catalogProperties = ImmutableMap.copyOf(Objects.requireNonNull(catalogProperties, "catalogProperties is null"));
        }
    }
}

