/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.operator.project.InputChannels;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.sql.gen.columnar.ColumnarFilter;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public final class IsNullColumnarFilter
implements ColumnarFilter {
    private final InputChannels inputChannels;

    public static Supplier<ColumnarFilter> createIsNullColumnarFilter(SpecialForm specialForm) {
        Preconditions.checkArgument((specialForm.form() == SpecialForm.Form.IS_NULL ? 1 : 0) != 0, (String)"specialForm %s should be IS_NULL", (Object)specialForm);
        Preconditions.checkArgument((specialForm.arguments().size() == 1 ? 1 : 0) != 0, (String)"specialForm %s should have single argument", (Object)specialForm);
        RowExpression rowExpression = specialForm.arguments().getFirst();
        if (!(rowExpression instanceof InputReferenceExpression)) {
            throw new UnsupportedOperationException("IS_NULL columnar evaluation is supported only for InputReferenceExpression");
        }
        InputReferenceExpression inputReference = (InputReferenceExpression)rowExpression;
        return () -> new IsNullColumnarFilter(inputReference);
    }

    private IsNullColumnarFilter(InputReferenceExpression inputReference) {
        this.inputChannels = new InputChannels((List<Integer>)ImmutableList.of((Object)inputReference.field()), (Set<Integer>)ImmutableSet.of((Object)inputReference.field()));
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public int filterPositionsRange(ConnectorSession session, int[] outputPositions, int offset, int size, SourcePage page) {
        ValueBlock block = (ValueBlock)page.getBlock(0);
        if (!block.mayHaveNull()) {
            return 0;
        }
        Optional isNullsBlock = block.getNulls();
        if (isNullsBlock.isEmpty()) {
            return 0;
        }
        byte[] isNull = ((ByteArrayBlock)isNullsBlock.get()).getRawValues();
        int isNullOffset = ((ByteArrayBlock)isNullsBlock.get()).getRawValuesOffset();
        int nullPositionsCount = 0;
        for (int position = offset; position < offset + size; ++position) {
            outputPositions[nullPositionsCount] = position;
            nullPositionsCount += isNull[isNullOffset + position];
        }
        return nullPositionsCount;
    }

    @Override
    public int filterPositionsList(ConnectorSession session, int[] outputPositions, int[] activePositions, int offset, int size, SourcePage page) {
        ValueBlock block = (ValueBlock)page.getBlock(0);
        if (!block.mayHaveNull()) {
            return 0;
        }
        Optional isNullsBlock = block.getNulls();
        if (isNullsBlock.isEmpty()) {
            return 0;
        }
        byte[] isNull = ((ByteArrayBlock)isNullsBlock.get()).getRawValues();
        int isNullOffset = ((ByteArrayBlock)isNullsBlock.get()).getRawValuesOffset();
        int nullPositionsCount = 0;
        for (int index = offset; index < offset + size; ++index) {
            int position;
            outputPositions[nullPositionsCount] = position = activePositions[index];
            nullPositionsCount += isNull[isNullOffset + position];
        }
        return nullPositionsCount;
    }
}

