/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonSerialize
public record Case(List<WhenClause> whenClauses, Expression defaultValue) implements Expression
{
    public Case {
        whenClauses = ImmutableList.copyOf(whenClauses);
        Objects.requireNonNull(defaultValue, "defaultValue is null");
        for (WhenClause clause : whenClauses) {
            IrUtils.validateType((Type)BooleanType.BOOLEAN, clause.getOperand());
        }
        for (int i = 1; i < whenClauses.size(); ++i) {
            IrUtils.validateType(((WhenClause)whenClauses.getFirst()).getResult().type(), ((WhenClause)whenClauses.get(i)).getResult());
        }
        IrUtils.validateType(((WhenClause)whenClauses.getFirst()).getResult().type(), defaultValue);
    }

    @Override
    public Type type() {
        return this.whenClauses.getFirst().getResult().type();
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitCase(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.whenClauses.forEach(clause -> {
            builder.add((Object)clause.getOperand());
            builder.add((Object)clause.getResult());
        });
        builder.add((Object)this.defaultValue);
        return builder.build();
    }

    @Override
    public String toString() {
        return "Case(%s, %s)".formatted(this.whenClauses.stream().map(WhenClause::toString).collect(Collectors.joining(", ")), this.defaultValue);
    }
}

