/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.sql.ir.Bind;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class EvaluateBind
implements IrOptimizerRule {
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> contextBindings) {
        int i;
        if (!(expression instanceof Bind)) {
            return Optional.empty();
        }
        Bind bind = (Bind)expression;
        if (bind.values().stream().noneMatch(Constant.class::isInstance)) {
            return Optional.empty();
        }
        HashMap<String, Constant> bindings = new HashMap<String, Constant>();
        ArrayList<Symbol> newArguments = new ArrayList<Symbol>();
        ArrayList<Expression> newBindings = new ArrayList<Expression>();
        for (i = 0; i < bind.values().size(); ++i) {
            Symbol argument = bind.function().arguments().get(i);
            Expression value = bind.values().get(i);
            if (value instanceof Constant) {
                Constant constant = (Constant)value;
                bindings.put(argument.name(), constant);
                continue;
            }
            newArguments.add(argument);
            newBindings.add(value);
        }
        for (i = bind.values().size(); i < bind.function().arguments().size(); ++i) {
            newArguments.add(bind.function().arguments().get(i));
        }
        Optional<Expression> body = this.substituteBindings(bind.function().body(), bindings);
        if (body.isEmpty()) {
            return Optional.empty();
        }
        if (newBindings.isEmpty()) {
            return Optional.of(new Lambda(newArguments, body.orElseThrow()));
        }
        return Optional.of(new Bind(newBindings, new Lambda(newArguments, body.orElseThrow())));
    }

    private Optional<Expression> substituteBindings(Expression expression, final Map<String, Constant> bindings) {
        ExpressionTreeRewriter<Void> rewriter = new ExpressionTreeRewriter<Void>(new ExpressionRewriter<Void>(this){

            @Override
            public Expression rewriteReference(Reference reference, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Constant constant = (Constant)bindings.get(reference.name());
                return constant == null ? reference : constant;
            }
        });
        Expression rewritten = rewriter.rewrite(expression, null);
        return rewritten != expression ? Optional.of(rewritten) : Optional.empty();
    }
}

