/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EvaluateCase
implements IrOptimizerRule {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Object defaultValue;
        if (!(expression instanceof Case)) return Optional.empty();
        Case case_ = (Case)expression;
        Object object = case_.whenClauses();
        List<WhenClause> whenClauses = object;
        try {
            defaultValue = object = case_.defaultValue();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        for (WhenClause whenClause : whenClauses) {
            Expression operand = whenClause.getOperand();
            if (operand.equals(Booleans.TRUE)) {
                return Optional.of(whenClause.getResult());
            }
            if (operand instanceof Constant) continue;
            return Optional.empty();
        }
        return Optional.of(defaultValue);
    }
}

