/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RemoveRedundantCaseClauses
implements IrOptimizerRule {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Object defaultValue;
        if (!(expression instanceof Case)) return Optional.empty();
        Case case_ = (Case)expression;
        Object object = case_.whenClauses();
        List<WhenClause> whenClauses = object;
        try {
            defaultValue = object = case_.defaultValue();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ArrayList<WhenClause> newClauses = new ArrayList<WhenClause>();
        Object newDefault = defaultValue;
        HashSet<Expression> seen = new HashSet<Expression>();
        boolean changed = false;
        for (WhenClause whenClause : whenClauses) {
            if (seen.contains(whenClause.getOperand()) || whenClause.getOperand().equals(Booleans.FALSE) || whenClause.getOperand().equals(Booleans.NULL_BOOLEAN)) {
                changed = true;
                continue;
            }
            if (whenClause.getOperand().equals(Booleans.TRUE)) {
                changed = true;
                newDefault = whenClause.getResult();
                break;
            }
            newClauses.add(whenClause);
            if (!DeterminismEvaluator.isDeterministic(whenClause.getOperand())) continue;
            seen.add(whenClause.getOperand());
        }
        if (!changed) {
            return Optional.empty();
        }
        if (!newClauses.isEmpty()) return Optional.of(new Case(newClauses, (Expression)newDefault));
        return Optional.of(newDefault);
    }
}

