/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.sql.planner.Symbol;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class SymbolKeyDeserializer
extends KeyDeserializer {
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private final TypeManager typeManager;

    @Inject
    public SymbolKeyDeserializer(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public Object deserializeKey(String key, DeserializationContext context) {
        String[] parts = key.split(":");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)("Expected two parts, found: " + parts.length));
        String name = new String(DECODER.decode(parts[0].getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        String type = new String(DECODER.decode(parts[1].getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        return new Symbol(this.typeManager.getType(TypeId.of((String)type)), name);
    }
}

