/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import java.util.Objects;
import java.util.Set;

public class AggregatedSetDescriptor {
    private final Set<IrLabel> labels;
    private final boolean running;

    @JsonCreator
    public AggregatedSetDescriptor(Set<IrLabel> labels, boolean running) {
        this.labels = Objects.requireNonNull(labels, "labels is null");
        this.running = running;
    }

    @JsonProperty
    public Set<IrLabel> getLabels() {
        return this.labels;
    }

    @JsonProperty
    public boolean isRunning() {
        return this.running;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregatedSetDescriptor that = (AggregatedSetDescriptor)o;
        return this.labels.equals(that.labels) && this.running == that.running;
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.running);
    }
}

