/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class BooleanOperators {
    private static final Slice TRUE = Slices.copiedBuffer((String)"true", (Charset)StandardCharsets.US_ASCII);
    private static final Slice FALSE = Slices.copiedBuffer((String)"false", (Charset)StandardCharsets.US_ASCII);

    private BooleanOperators() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="boolean") boolean value) {
        return value ? 1.0 : 0.0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="real")
    public static long castToReal(@SqlType(value="boolean") boolean value) {
        return value ? (long)Float.floatToRawIntBits(1.0f) : (long)Float.floatToRawIntBits(0.0f);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="boolean") boolean value) {
        return value ? TRUE : FALSE;
    }

    @SqlType(value="boolean")
    @ScalarFunction(value="$not", hidden=true)
    public static boolean not(@SqlType(value="boolean") boolean value) {
        return !value;
    }
}

