/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogStoreManager;
import io.trino.connector.InMemoryCatalogStore;
import io.trino.connector.MockConnectorPlugin;
import io.trino.execution.CreateCatalogTask;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.security.AccessControl;
import io.trino.spi.Plugin;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.catalog.CatalogProperties;
import io.trino.spi.catalog.CatalogStore;
import io.trino.spi.catalog.CatalogStoreFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorName;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestCreateCatalogTask {
    private static final String TEST_CATALOG = "test_catalog";
    private static final ImmutableList<Property> TPCH_PROPERTIES = ImmutableList.of((Object)new Property(new Identifier("tpch.partitioning-enabled"), (Expression)new StringLiteral("false")));
    protected QueryRunner queryRunner;
    private QueryStateMachine queryStateMachine;
    private CreateCatalogTask task;

    @BeforeEach
    public void setUp() {
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(SessionTestUtils.TEST_SESSION);
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin(new FailConnectorFactory()));
        Map tasks = (Map)queryRunner.getCoordinator().getInstance(new Key<Map<Class<? extends Statement>, DataDefinitionTask<?>>>(this){});
        this.task = (CreateCatalogTask)tasks.get(CreateCatalog.class);
        this.queryStateMachine = QueryStateMachine.begin(Optional.empty(), (String)"test", Optional.empty(), (Session)queryRunner.getDefaultSession(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)queryRunner.getTransactionManager(), (AccessControl)queryRunner.getAccessControl(), (Executor)MoreExecutors.directExecutor(), (Metadata)queryRunner.getPlannerContext().getMetadata(), (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, Optional.empty(), (NodeVersion)new NodeVersion("test"));
        this.queryRunner = queryRunner;
    }

    @AfterEach
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
        }
        this.queryRunner = null;
    }

    @Test
    public void testDuplicatedCreateCatalog() {
        CreateCatalog statement = new CreateCatalog(new NodeLocation(1, 1), new Identifier(TEST_CATALOG), false, new Identifier("tpch"), TPCH_PROPERTIES, Optional.empty(), Optional.empty());
        MoreFutures.getFutureValue((Future)this.task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assertions.assertThat((boolean)this.queryRunner.getPlannerContext().getMetadata().catalogExists(this.queryStateMachine.getSession(), TEST_CATALOG)).isTrue();
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)this.task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessage("Catalog '%s' already exists", new Object[]{TEST_CATALOG});
    }

    @Test
    public void testCaseInsensitiveDuplicatedCreateCatalog() {
        CreateCatalog statement = new CreateCatalog(new NodeLocation(1, 1), new Identifier(TEST_CATALOG.toUpperCase(Locale.ENGLISH)), false, new Identifier("tpch"), TPCH_PROPERTIES, Optional.empty(), Optional.empty());
        MoreFutures.getFutureValue((Future)this.task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assertions.assertThat((boolean)this.queryRunner.getPlannerContext().getMetadata().catalogExists(this.queryStateMachine.getSession(), TEST_CATALOG)).isTrue();
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)this.task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessage("Catalog '%s' already exists", new Object[]{TEST_CATALOG});
    }

    @Test
    public void testDuplicatedCreateCatalogIfNotExists() {
        CreateCatalog statement = new CreateCatalog(new NodeLocation(1, 1), new Identifier(TEST_CATALOG), true, new Identifier("tpch"), TPCH_PROPERTIES, Optional.empty(), Optional.empty());
        MoreFutures.getFutureValue((Future)this.task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assertions.assertThat((boolean)this.queryRunner.getPlannerContext().getMetadata().catalogExists(this.queryStateMachine.getSession(), TEST_CATALOG)).isTrue();
        MoreFutures.getFutureValue((Future)this.task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assertions.assertThat((boolean)this.queryRunner.getPlannerContext().getMetadata().catalogExists(this.queryStateMachine.getSession(), TEST_CATALOG)).isTrue();
    }

    @Test
    public void failCreateCatalog() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)this.task.execute(new CreateCatalog(new NodeLocation(1, 1), new Identifier(TEST_CATALOG), true, new Identifier("fail"), (List)ImmutableList.of(), Optional.empty(), Optional.empty()), this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessageContaining("TEST create catalog fail: test_catalog");
    }

    @Test
    public void testAddOrReplaceCatalogFail() {
        try (StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(SessionTestUtils.TEST_SESSION, builder -> builder.setAdditionalModule((Module)new FailingAddOrReplaceCatalogStoreModule()).addProperty("catalog.store", "failing_add_or_replace"));){
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            Map tasks = (Map)queryRunner.getCoordinator().getInstance(new Key<Map<Class<? extends Statement>, DataDefinitionTask<?>>>(this){});
            CreateCatalogTask task = (CreateCatalogTask)tasks.get(CreateCatalog.class);
            QueryStateMachine queryStateMachine = QueryStateMachine.begin(Optional.empty(), (String)"test", Optional.empty(), (Session)queryRunner.getDefaultSession(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)queryRunner.getTransactionManager(), (AccessControl)queryRunner.getAccessControl(), (Executor)MoreExecutors.directExecutor(), (Metadata)queryRunner.getPlannerContext().getMetadata(), (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, Optional.empty(), (NodeVersion)new NodeVersion("test"));
            CreateCatalog statement = new CreateCatalog(new NodeLocation(1, 1), new Identifier(TEST_CATALOG), true, new Identifier("tpch"), TPCH_PROPERTIES, Optional.empty(), Optional.empty());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)task.execute(statement, queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).isInstanceOf(RuntimeException.class)).hasMessageContaining("Add or replace catalog failed");
            Assertions.assertThat((boolean)queryRunner.getPlannerContext().getMetadata().catalogExists(queryStateMachine.getSession(), TEST_CATALOG)).isFalse();
        }
    }

    private static class FailConnectorFactory
    implements ConnectorFactory {
        private FailConnectorFactory() {
        }

        public String getName() {
            return "fail";
        }

        public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
            throw new IllegalArgumentException("TEST create catalog fail: " + catalogName);
        }
    }

    private static class FailingAddOrReplaceCatalogStoreModule
    implements Module {
        private FailingAddOrReplaceCatalogStoreModule() {
        }

        public void configure(Binder binder) {
        }

        @Provides
        @Singleton
        public CatalogStoreFactory createCatalogStoreFactory(CatalogStoreManager catalogStoreManager) {
            FailingAddOrReplaceCatalogStoreFactory factory = new FailingAddOrReplaceCatalogStoreFactory();
            catalogStoreManager.addCatalogStoreFactory((CatalogStoreFactory)factory);
            return factory;
        }
    }

    private static class FailingAddOrReplaceCatalogStore
    implements CatalogStore {
        private final CatalogStore delegate;

        FailingAddOrReplaceCatalogStore(CatalogStore delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public Collection<CatalogStore.StoredCatalog> getCatalogs() {
            return this.delegate.getCatalogs();
        }

        public CatalogProperties createCatalogProperties(CatalogName catalogName, ConnectorName connectorName, Map<String, String> properties) {
            return this.delegate.createCatalogProperties(catalogName, connectorName, properties);
        }

        public void addOrReplaceCatalog(CatalogProperties catalogProperties) {
            throw new RuntimeException("Add or replace catalog failed");
        }

        public void removeCatalog(CatalogName catalogName) {
            this.delegate.removeCatalog(catalogName);
        }
    }

    private static class FailingAddOrReplaceCatalogStoreFactory
    implements CatalogStoreFactory {
        private FailingAddOrReplaceCatalogStoreFactory() {
        }

        public String getName() {
            return "failing_add_or_replace";
        }

        public CatalogStore create(Map<String, String> config) {
            return new FailingAddOrReplaceCatalogStore((CatalogStore)new InMemoryCatalogStore());
        }
    }
}

