/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SplitAssignment;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.memory.MemoryPool;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.TableScanOperator;
import io.trino.operator.TaskContext;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.PageConsumerOperator;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestMemoryBlocking {
    private static final QueryId QUERY_ID = new QueryId("test_query");
    private static final TaskId TASK_ID = new TaskId(new StageId(QUERY_ID, 0), 0, 0);
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private MemoryPool memoryPool;

    @BeforeEach
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        TaskContext taskContext = TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setQueryMaxMemory(DataSize.valueOf((String)"100MB")).setMemoryPoolSize(DataSize.valueOf((String)"10B")).setQueryId(QUERY_ID).build();
        this.memoryPool = taskContext.getQueryContext().getMemoryPool();
        this.driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterEach
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testTableScanMemoryBlocking() {
        PlanNodeId sourceId = new PlanNodeId("source");
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        TableScanOperator source = new TableScanOperator(this.driverContext.addOperatorContext(1, new PlanNodeId("test"), "values"), sourceId, (arg_0, arg_1, arg_2, arg_3, arg_4) -> TestMemoryBlocking.lambda$testTableScanMemoryBlocking$0((List)types, arg_0, arg_1, arg_2, arg_3, arg_4), TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), DynamicFilter.EMPTY);
        PageConsumerOperator sink = this.createSinkOperator((List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        Assertions.assertThat((Object)driver.getDriverContext()).isSameAs((Object)this.driverContext);
        Assertions.assertThat((boolean)driver.isFinished()).isFalse();
        Split testSplit = new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplit());
        driver.updateSplitAssignment(new SplitAssignment(sourceId, (Set)ImmutableSet.of((Object)new ScheduledSplit(0L, sourceId, testSplit)), true));
        ListenableFuture blocked = driver.processForDuration(new Duration(1.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((boolean)blocked.isDone()).isTrue();
        Assertions.assertThat((boolean)source.getOperatorContext().isWaitingForMemory().isDone()).isFalse();
        for (int i = 0; i < 10; ++i) {
            blocked = driver.processForDuration(new Duration(1.0, TimeUnit.NANOSECONDS));
            Assertions.assertThat((boolean)blocked.isDone()).isFalse();
            Assertions.assertThat((boolean)source.getOperatorContext().isWaitingForMemory().isDone()).isFalse();
        }
        this.memoryPool.free(TASK_ID, "test", this.memoryPool.getReservedBytes());
        Assertions.assertThat((boolean)source.getOperatorContext().isWaitingForMemory().isDone()).isTrue();
        blocked = driver.processForDuration(new Duration(1.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((boolean)blocked.isDone()).isTrue();
    }

    private PageConsumerOperator createSinkOperator(List<Type> types) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), types);
        return new PageConsumerOperator(this.driverContext.addOperatorContext(2, new PlanNodeId("test"), "sink"), arg_0 -> ((MaterializedResult.Builder)resultBuilder).page(arg_0), Function.identity());
    }

    private static /* synthetic */ ConnectorPageSource lambda$testTableScanMemoryBlocking$0(List types, Session session, Split split, TableHandle table, List columns, DynamicFilter dynamicFilter) {
        return new FixedPageSource(RowPagesBuilder.rowPagesBuilder(types).addSequencePage(10, 1).addSequencePage(10, 1).addSequencePage(10, 1).addSequencePage(10, 1).addSequencePage(10, 1).build());
    }

    private static class TestSplit
    implements ConnectorSplit {
        private TestSplit() {
        }

        public Map<String, String> getSplitInfo() {
            return Map.of();
        }

        public long getRetainedSizeInBytes() {
            return 0L;
        }
    }
}

