/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.FeaturesConfig;
import io.trino.client.NodeVersion;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.OperatorNameUtil;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.Signature;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeVariableConstraint;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.type.BlockTypeOperators;
import io.trino.type.UnknownType;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGlobalFunctionCatalog {
    @Test
    public void testIdentityCast() {
        BoundSignature exactOperator = new TestingFunctionResolution().getCoercion((Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG).signature();
        Assertions.assertThat((Object)exactOperator).isEqualTo((Object)new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((OperatorType)OperatorType.CAST), (Type)HyperLogLogType.HYPER_LOG_LOG, (List)ImmutableList.of((Object)HyperLogLogType.HYPER_LOG_LOG)));
    }

    @Test
    public void testExactMatchBeforeCoercion() {
        TestingFunctionResolution functionResolution = new TestingFunctionResolution();
        boolean foundOperator = false;
        for (FunctionMetadata function : TestGlobalFunctionCatalog.listOperators(functionResolution)) {
            OperatorType operatorType = OperatorNameUtil.unmangleOperator((String)function.getCanonicalName());
            if (operatorType == OperatorType.CAST || operatorType == OperatorType.SATURATED_FLOOR_CAST || !function.getSignature().getTypeVariableConstraints().isEmpty() || function.getSignature().getArgumentTypes().stream().anyMatch(TypeSignature::isCalculated)) continue;
            List argumentTypes = (List)function.getSignature().getArgumentTypes().stream().map(arg_0 -> ((TypeManager)functionResolution.getPlannerContext().getTypeManager()).getType(arg_0)).collect(ImmutableList.toImmutableList());
            BoundSignature exactOperator = functionResolution.resolveOperator(operatorType, argumentTypes).signature();
            Assertions.assertThat((Object)exactOperator.toSignature()).isEqualTo((Object)function.getSignature());
            foundOperator = true;
        }
        Assertions.assertThat((boolean)foundOperator).isTrue();
    }

    @Test
    public void testDuplicateFunctions() {
        InternalFunctionBundle functionBundle = InternalFunctionBundle.extractFunctions(CustomAdd.class);
        TypeOperators typeOperators = new TypeOperators();
        GlobalFunctionCatalog globalFunctionCatalog = new GlobalFunctionCatalog(() -> {
            throw new UnsupportedOperationException();
        }, () -> {
            throw new UnsupportedOperationException();
        }, () -> {
            throw new UnsupportedOperationException();
        });
        globalFunctionCatalog.addFunctions(SystemFunctionBundle.create((FeaturesConfig)new FeaturesConfig(), (TypeOperators)typeOperators, (BlockTypeOperators)new BlockTypeOperators(typeOperators), (NodeVersion)NodeVersion.UNKNOWN));
        globalFunctionCatalog.addFunctions((FunctionBundle)functionBundle);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestGlobalFunctionCatalog.lambda$testDuplicateFunctions$3(globalFunctionCatalog, (FunctionBundle)functionBundle)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("\\QFunction already registered: custom_add(bigint,bigint):bigint\\E");
    }

    @Test
    public void testConflictingScalarAggregation() {
        InternalFunctionBundle functions = InternalFunctionBundle.extractFunctions(ScalarSum.class);
        TypeOperators typeOperators = new TypeOperators();
        GlobalFunctionCatalog globalFunctionCatalog = new GlobalFunctionCatalog(() -> {
            throw new UnsupportedOperationException();
        }, () -> {
            throw new UnsupportedOperationException();
        }, () -> {
            throw new UnsupportedOperationException();
        });
        globalFunctionCatalog.addFunctions(SystemFunctionBundle.create((FeaturesConfig)new FeaturesConfig(), (TypeOperators)typeOperators, (BlockTypeOperators)new BlockTypeOperators(typeOperators), (NodeVersion)NodeVersion.UNKNOWN));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestGlobalFunctionCatalog.lambda$testConflictingScalarAggregation$7(globalFunctionCatalog, (FunctionBundle)functions)).isInstanceOf(IllegalStateException.class)).hasMessage("'sum' is both an aggregation and a scalar function");
    }

    @Test
    public void testResolveFunctionByExactMatch() {
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("bigint", "bigint")).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).returns(TestGlobalFunctionCatalog.functionSignature("bigint", "bigint"));
    }

    @Test
    public void testResolveTypeParametrizedFunction() {
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature((List<String>)ImmutableList.of((Object)"T", (Object)"T"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)TypeVariableConstraint.typeVariable((String)"T")))).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).returns(TestGlobalFunctionCatalog.functionSignature("bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionWithCoercion() {
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("decimal(p,s)", "double"), TestGlobalFunctionCatalog.functionSignature("decimal(p,s)", "decimal(p,s)"), TestGlobalFunctionCatalog.functionSignature("double", "double")).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).returns(TestGlobalFunctionCatalog.functionSignature("decimal(19,0)", "decimal(19,0)"));
    }

    @Test
    public void testAmbiguousCallWithNoCoercion() {
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("decimal(p,s)", "decimal(p,s)"), TestGlobalFunctionCatalog.functionSignature((List<String>)ImmutableList.of((Object)"T", (Object)"T"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)TypeVariableConstraint.typeVariable((String)"T")))).forParameters(new Type[]{DecimalType.createDecimalType((int)3, (int)1), DecimalType.createDecimalType((int)3, (int)1)}).returns(TestGlobalFunctionCatalog.functionSignature("decimal(3,1)", "decimal(3,1)"));
    }

    @Test
    public void testAmbiguousCallWithCoercion() {
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("decimal(p,s)", "double"), TestGlobalFunctionCatalog.functionSignature("double", "decimal(p,s)")).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).failsWithMessage("Could not choose a best candidate operator. Explicit type casts must be added.");
    }

    @Test
    public void testResolveFunctionWithCoercionInTypes() {
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("array(decimal(p,s))", "array(double)"), TestGlobalFunctionCatalog.functionSignature("array(decimal(p,s))", "array(decimal(p,s))"), TestGlobalFunctionCatalog.functionSignature("array(double)", "array(double)")).forParameters(new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)}).returns(TestGlobalFunctionCatalog.functionSignature("array(decimal(19,0))", "array(decimal(19,0))"));
    }

    @Test
    public void testResolveFunctionWithVariableArity() {
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("double", "double", "double"), TestGlobalFunctionCatalog.functionSignature("decimal(p,s)").variableArity()).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).returns(TestGlobalFunctionCatalog.functionSignature("decimal(19,0)", "decimal(19,0)", "decimal(19,0)"));
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("double", "double", "double"), TestGlobalFunctionCatalog.functionSignature("bigint").variableArity()).forParameters(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).returns(TestGlobalFunctionCatalog.functionSignature("bigint", "bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionWithVariadicBound() {
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("bigint", "bigint", "bigint"), TestGlobalFunctionCatalog.functionSignature((List<String>)ImmutableList.of((Object)"T1", (Object)"T2", (Object)"T3"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)TypeVariableConstraint.builder((String)"T1").variadicBound("row").build(), (Object)TypeVariableConstraint.builder((String)"T2").variadicBound("row").build(), (Object)TypeVariableConstraint.builder((String)"T3").variadicBound("row").build()))).forParameters(new Type[]{UnknownType.UNKNOWN, BigintType.BIGINT, BigintType.BIGINT}).returns(TestGlobalFunctionCatalog.functionSignature("bigint", "bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionForUnknown() {
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("bigint")).forParameters(new Type[]{UnknownType.UNKNOWN}).returns(TestGlobalFunctionCatalog.functionSignature("bigint"));
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("bigint"), TestGlobalFunctionCatalog.functionSignature("integer")).forParameters(new Type[]{UnknownType.UNKNOWN}).returns(TestGlobalFunctionCatalog.functionSignature("integer"));
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature("bigint", "bigint"), TestGlobalFunctionCatalog.functionSignature("integer", "integer")).forParameters(new Type[]{UnknownType.UNKNOWN, BigintType.BIGINT}).returns(TestGlobalFunctionCatalog.functionSignature("bigint", "bigint"));
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature((List<String>)ImmutableList.of((Object)"JoniRegExp"), "boolean"), TestGlobalFunctionCatalog.functionSignature((List<String>)ImmutableList.of((Object)"integer"), "boolean")).forParameters(new Type[]{UnknownType.UNKNOWN}).returns(TestGlobalFunctionCatalog.functionSignature("JoniRegExp"));
        TestGlobalFunctionCatalog.assertThatResolveFunction().among(TestGlobalFunctionCatalog.functionSignature((List<String>)ImmutableList.of((Object)"JoniRegExp"), "JoniRegExp"), TestGlobalFunctionCatalog.functionSignature((List<String>)ImmutableList.of((Object)"integer"), "integer")).forParameters(new Type[]{UnknownType.UNKNOWN}).failsWithMessage("Could not choose a best candidate operator. Explicit type casts must be added.");
    }

    private static List<FunctionMetadata> listOperators(TestingFunctionResolution functionResolution) {
        Set operatorNames = (Set)Arrays.stream(OperatorType.values()).map(OperatorNameUtil::mangleOperatorName).collect(ImmutableSet.toImmutableSet());
        return (List)functionResolution.listGlobalFunctions().stream().filter(function -> operatorNames.contains(function.getCanonicalName())).collect(ImmutableList.toImmutableList());
    }

    private static Signature.Builder functionSignature(String ... argumentTypes) {
        return TestGlobalFunctionCatalog.functionSignature((List<String>)ImmutableList.copyOf((Object[])argumentTypes), "boolean");
    }

    private static Signature.Builder functionSignature(List<String> arguments, String returnType) {
        return TestGlobalFunctionCatalog.functionSignature(arguments, returnType, (List<TypeVariableConstraint>)ImmutableList.of());
    }

    private static Signature.Builder functionSignature(List<String> arguments, String returnType, List<TypeVariableConstraint> typeVariableConstraints) {
        ImmutableSet literalParameters = ImmutableSet.of((Object)"p", (Object)"s", (Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2", (Object[])new String[]{"p3", "s3"});
        List argumentSignatures = (List)arguments.stream().map(signature -> TypeSignatureTranslator.parseTypeSignature((String)signature, (Set)literalParameters)).collect(ImmutableList.toImmutableList());
        return Signature.builder().returnType(TypeSignatureTranslator.parseTypeSignature((String)returnType, (Set)literalParameters)).argumentTypes(argumentSignatures).typeVariableConstraints(typeVariableConstraints);
    }

    private static ResolveFunctionAssertion assertThatResolveFunction() {
        return new ResolveFunctionAssertion();
    }

    private static /* synthetic */ void lambda$testConflictingScalarAggregation$7(GlobalFunctionCatalog globalFunctionCatalog, FunctionBundle functions) throws Throwable {
        globalFunctionCatalog.addFunctions(functions);
    }

    private static /* synthetic */ void lambda$testDuplicateFunctions$3(GlobalFunctionCatalog globalFunctionCatalog, FunctionBundle functionBundle) throws Throwable {
        globalFunctionCatalog.addFunctions(functionBundle);
    }

    public static final class CustomAdd {
        private CustomAdd() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long customAdd(@SqlType(value="bigint") long x, @SqlType(value="bigint") long y) {
            return x + y;
        }
    }

    public static final class ScalarSum {
        private ScalarSum() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long sum(@SqlType(value="bigint") long a, @SqlType(value="bigint") long b) {
            return a + b;
        }
    }

    private static class ResolveFunctionAssertion {
        private static final String TEST_FUNCTION_NAME = "TEST_FUNCTION_NAME";
        private List<Signature.Builder> functionSignatures = ImmutableList.of();
        private List<TypeSignature> parameterTypes = ImmutableList.of();

        private ResolveFunctionAssertion() {
        }

        public ResolveFunctionAssertion among(Signature.Builder ... functionSignatures) {
            this.functionSignatures = ImmutableList.copyOf((Object[])functionSignatures);
            return this;
        }

        public ResolveFunctionAssertion forParameters(Type ... parameters) {
            this.parameterTypes = ResolveFunctionAssertion.parseTypeSignatures(parameters);
            return this;
        }

        public ResolveFunctionAssertion returns(Signature.Builder functionSignature) {
            Signature expectedSignature = functionSignature.build();
            Signature actualSignature = this.resolveSignature().toSignature();
            Assertions.assertThat((Object)actualSignature).isEqualTo((Object)expectedSignature);
            return this;
        }

        public ResolveFunctionAssertion failsWithMessage(String ... messages) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(this::resolveSignature).isInstanceOf(RuntimeException.class)).hasMessageContainingAll((CharSequence[])messages);
            return this;
        }

        private BoundSignature resolveSignature() {
            return new TestingFunctionResolution((FunctionBundle)this.createFunctionsFromSignatures()).resolveFunction(TEST_FUNCTION_NAME, TypeSignatureProvider.fromTypeSignatures(this.parameterTypes)).signature();
        }

        private InternalFunctionBundle createFunctionsFromSignatures() {
            ImmutableList.Builder functions = ImmutableList.builder();
            for (Signature.Builder functionSignature : this.functionSignatures) {
                FunctionMetadata functionMetadata = FunctionMetadata.scalarBuilder((String)TEST_FUNCTION_NAME).signature(functionSignature.build()).nondeterministic().description("testing function that does nothing").build();
                functions.add((Object)new SqlScalarFunction(this, functionMetadata){

                    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
                        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(boundSignature.getArity(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), MethodHandles.identity(Void.class));
                    }
                });
            }
            return new InternalFunctionBundle((List)functions.build());
        }

        private static List<TypeSignature> parseTypeSignatures(Type ... signatures) {
            return ImmutableList.copyOf((Object[])signatures).stream().map(Type::getTypeSignature).collect(Collectors.toList());
        }
    }
}

