/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.BoundVariables;
import io.trino.metadata.SignatureBinder;
import io.trino.metadata.TypeVariables;
import io.trino.spi.function.Signature;
import io.trino.spi.function.TypeVariableConstraint;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.type.FunctionType;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;

public class TestSignatureBinder {
    private static final TypeVariables NO_BOUND_VARIABLES = new BoundVariables();

    @Test
    public void testBindLiteralForDecimal() {
        TypeSignature leftType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p1"), TypeSignatureParameter.typeVariable((String)"s1")});
        TypeSignature rightType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p2"), TypeSignatureParameter.typeVariable((String)"s2")});
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(leftType).argumentType(rightType).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1), DecimalType.createDecimalType((int)1, (int)0)).produces((TypeVariables)new BoundVariables().setLongVariable("p1", Long.valueOf(2L)).setLongVariable("s1", Long.valueOf(1L)).setLongVariable("p2", Long.valueOf(1L)).setLongVariable("s2", Long.valueOf(0L)));
    }

    @Test
    public void testBindPartialDecimal() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.numericParameter((long)4L), TypeSignatureParameter.typeVariable((String)"s")})).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1)).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("s", Long.valueOf(1L)));
        function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.numericParameter((long)1L)})).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)0)).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("p", Long.valueOf(3L)));
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1)).produces((TypeVariables)new BoundVariables().setLongVariable("p", Long.valueOf(2L)));
        this.assertThat(function).boundTo(BigintType.BIGINT).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("p", Long.valueOf(20L)));
    }

    @Test
    public void testBindLiteralForVarchar() {
        TypeSignature leftType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        TypeSignature rightType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"y")});
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(leftType).argumentType(rightType).build();
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)42), VarcharType.createVarcharType((int)44)).produces((TypeVariables)new BoundVariables().setLongVariable("x", Long.valueOf(42L)).setLongVariable("y", Long.valueOf(44L)));
        this.assertThat(function).boundTo(UnknownType.UNKNOWN, VarcharType.createVarcharType((int)44)).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("x", Long.valueOf(0L)).setLongVariable("y", Long.valueOf(44L)));
    }

    @Test
    public void testBindLiteralForRepeatedVarcharWithReturn() {
        TypeSignature leftType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        TypeSignature rightType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(leftType).argumentType(rightType).build();
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)44), VarcharType.createVarcharType((int)44)).produces((TypeVariables)new BoundVariables().setLongVariable("x", Long.valueOf(44L)));
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)44), VarcharType.createVarcharType((int)42)).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("x", Long.valueOf(44L)));
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)42), VarcharType.createVarcharType((int)44)).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("x", Long.valueOf(44L)));
        this.assertThat(function).boundTo(UnknownType.UNKNOWN, VarcharType.createVarcharType((int)44)).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("x", Long.valueOf(44L)));
    }

    @Test
    public void testBindLiteralForRepeatedDecimal() {
        TypeSignature leftType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")});
        TypeSignature rightType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")});
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(leftType).argumentType(rightType).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)10, (int)5), DecimalType.createDecimalType((int)10, (int)5)).produces((TypeVariables)new BoundVariables().setLongVariable("p", Long.valueOf(10L)).setLongVariable("s", Long.valueOf(5L)));
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)10, (int)8), DecimalType.createDecimalType((int)9, (int)8)).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("p", Long.valueOf(10L)).setLongVariable("s", Long.valueOf(8L)));
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)10, (int)2), DecimalType.createDecimalType((int)10, (int)8)).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("p", Long.valueOf(16L)).setLongVariable("s", Long.valueOf(8L)));
        this.assertThat(function).boundTo(UnknownType.UNKNOWN, DecimalType.createDecimalType((int)10, (int)5)).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("p", Long.valueOf(10L)).setLongVariable("s", Long.valueOf(5L)));
    }

    @Test
    public void testBindLiteralForRepeatedVarchar() {
        TypeSignature leftType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        TypeSignature rightType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        TypeSignature returnType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        Signature function = TestSignatureBinder.functionSignature().returnType(returnType).argumentType(leftType).argumentType(rightType).build();
        this.assertThat(function).withCoercion().boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)3), (Object)VarcharType.createVarcharType((int)5)), (Type)VarcharType.createVarcharType((int)5)).produces((TypeVariables)new BoundVariables().setLongVariable("x", Long.valueOf(5L)));
        this.assertThat(function).withCoercion().boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)3), (Object)VarcharType.createVarcharType((int)5)), (Type)VarcharType.createVarcharType((int)6)).produces((TypeVariables)new BoundVariables().setLongVariable("x", Long.valueOf(6L)));
    }

    @Test
    public void testBindUnknown() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).fails();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().succeeds();
    }

    @Test
    public void testBindMixedLiteralAndTypeVariables() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).typeVariable("T").argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}))).build();
        this.assertThat(function).boundTo(new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)1))).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)DecimalType.createDecimalType((int)2, (int)1)).setLongVariable("p", Long.valueOf(3L)).setLongVariable("s", Long.valueOf(1L)));
    }

    @Test
    public void testBindDifferentLiteralParameters() {
        TypeSignature argType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")});
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(argType).argumentType(argType).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1), DecimalType.createDecimalType((int)3, (int)1)).fails();
    }

    @Test
    public void testNoVariableReuseAcrossTypes() {
        TypeSignature leftType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p1"), TypeSignatureParameter.typeVariable((String)"s")});
        TypeSignature rightType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p2"), TypeSignatureParameter.typeVariable((String)"s")});
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(leftType).argumentType(rightType).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1), DecimalType.createDecimalType((int)3, (int)1)).produces(NO_BOUND_VARIABLES)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Literal parameters may not be shared across different types");
    }

    @Test
    public void testBindUnknownToDecimal() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")})).build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().produces((TypeVariables)new BoundVariables().setLongVariable("p", Long.valueOf(1L)).setLongVariable("s", Long.valueOf(0L)));
    }

    @Test
    public void testBindUnknownToConcreteArray() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.arrayType((TypeSignature)BooleanType.BOOLEAN.getTypeSignature())).build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().succeeds();
    }

    @Test
    public void testBindTypeVariablesBasedOnTheSecondArgument() {
        Signature function = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).typeVariable("T").build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN, DecimalType.createDecimalType((int)2, (int)1)).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)DecimalType.createDecimalType((int)2, (int)1)));
    }

    @Test
    public void testBindParametricTypeParameterToUnknown() {
        Signature function = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).typeVariable("T").build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).fails();
        this.assertThat(function).withCoercion().boundTo(UnknownType.UNKNOWN).succeeds();
    }

    @Test
    public void testBindUnknownToTypeParameter() {
        Signature function = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).typeVariable("T").build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)UnknownType.UNKNOWN));
    }

    @Test
    public void testBindDoubleToBigint() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        this.assertThat(function).boundTo(DoubleType.DOUBLE, BigintType.BIGINT).withCoercion().succeeds();
    }

    @Test
    public void testBindVarcharTemplateStyle() {
        Signature function = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T2", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T1", new TypeSignatureParameter[0])).comparableTypeParameter("T1").comparableTypeParameter("T2").build();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)42)), (Type)VarcharType.createVarcharType((int)1)).produces((TypeVariables)new BoundVariables().setTypeVariable("T1", (Type)VarcharType.createVarcharType((int)42)).setTypeVariable("T2", (Type)VarcharType.createVarcharType((int)1)));
    }

    @Test
    public void testBindVarchar() {
        Signature function = TestSignatureBinder.functionSignature().returnType(VarcharType.createVarcharType((int)42).getTypeSignature()).argumentType(VarcharType.createVarcharType((int)42).getTypeSignature()).build();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)1)), (Type)VarcharType.createVarcharType((int)1)).fails();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)1)), (Type)VarcharType.createVarcharType((int)1)).withCoercion().fails();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)1)), (Type)VarcharType.createVarcharType((int)42)).withCoercion().succeeds();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)44)), (Type)VarcharType.createVarcharType((int)44)).withCoercion().fails();
    }

    @Test
    public void testBindUnparametrizedVarchar() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build();
        this.assertThat(function).boundTo(VarcharType.VARCHAR).produces((TypeVariables)new BoundVariables().setLongVariable("x", Long.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    public void testBindToUnparametrizedVarcharIsImpossible() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType((Type)VarcharType.VARCHAR).build();
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)3)).withCoercion().succeeds();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().succeeds();
    }

    @Test
    public void testBasic() {
        Signature function = TestSignatureBinder.functionSignature().typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build();
        this.assertThat(function).boundTo(BigintType.BIGINT).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(function).boundTo(VarcharType.VARCHAR).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)VarcharType.VARCHAR));
        this.assertThat(function).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).fails();
        this.assertThat(function).boundTo(new ArrayType((Type)BigintType.BIGINT)).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)new ArrayType((Type)BigintType.BIGINT)));
    }

    @Test
    public void testMismatchedArgumentCount() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).build();
        this.assertThat(function).boundTo(BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT).fails();
        this.assertThat(function).boundTo(BigintType.BIGINT).fails();
    }

    @Test
    public void testNonParametric() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType((Type)BigintType.BIGINT).build();
        this.assertThat(function).boundTo(BigintType.BIGINT).succeeds();
        this.assertThat(function).boundTo(VarcharType.VARCHAR).withCoercion().fails();
        this.assertThat(function).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).withCoercion().fails();
        this.assertThat(function).boundTo(new ArrayType((Type)BigintType.BIGINT)).withCoercion().fails();
    }

    @Test
    public void testArray() {
        Signature getFunction = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).typeVariable("T").build();
        this.assertThat(getFunction).boundTo(new ArrayType((Type)BigintType.BIGINT)).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(getFunction).boundTo(BigintType.BIGINT).withCoercion().fails();
        this.assertThat(getFunction).boundTo(RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))).withCoercion().fails();
        Signature containsFunction = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).comparableTypeParameter("T").build();
        this.assertThat(containsFunction).boundTo(new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(containsFunction).boundTo(new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR).withCoercion().fails();
        this.assertThat(containsFunction).boundTo(new ArrayType((Type)HyperLogLogType.HYPER_LOG_LOG), HyperLogLogType.HYPER_LOG_LOG).withCoercion().fails();
        Signature castFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T2", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T1", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T2", new TypeSignatureParameter[0]))).typeVariable("T1").typeVariable("T2").build();
        this.assertThat(castFunction).boundTo(new ArrayType((Type)UnknownType.UNKNOWN), new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T1", (Type)UnknownType.UNKNOWN).setTypeVariable("T2", (Type)DecimalType.createDecimalType((int)2, (int)1)));
        Signature fooFunction = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).typeVariable("T").build();
        this.assertThat(fooFunction).boundTo(new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(fooFunction).boundTo(new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)VarcharType.VARCHAR)).withCoercion().fails();
    }

    @Test
    public void testMap() {
        Signature getValueFunction = TestSignatureBinder.functionSignature().returnType(new TypeSignature("V", new TypeSignatureParameter[0])).argumentType(TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("K", new TypeSignatureParameter[0])).typeVariable("K").typeVariable("V").build();
        this.assertThat(getValueFunction).boundTo(this.type(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())), BigintType.BIGINT).produces((TypeVariables)new BoundVariables().setTypeVariable("K", (Type)BigintType.BIGINT).setTypeVariable("V", (Type)VarcharType.VARCHAR));
        this.assertThat(getValueFunction).boundTo(this.type(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())), VarcharType.VARCHAR).withCoercion().fails();
    }

    @Test
    public void testRow() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.rowType((TypeSignatureParameter[])new TypeSignatureParameter[]{TypeSignatureParameter.anonymousField((TypeSignature)IntegerType.INTEGER.getTypeSignature())})).build();
        this.assertThat(function).boundTo(RowType.anonymous((List)ImmutableList.of((Object)TinyintType.TINYINT))).withCoercion().produces(NO_BOUND_VARIABLES);
        this.assertThat(function).boundTo(RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER))).withCoercion().produces(NO_BOUND_VARIABLES);
        this.assertThat(function).boundTo(RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))).withCoercion().fails();
        Signature biFunction = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.rowType((TypeSignatureParameter[])new TypeSignatureParameter[]{TypeSignatureParameter.anonymousField((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))})).argumentType(TypeSignature.rowType((TypeSignatureParameter[])new TypeSignatureParameter[]{TypeSignatureParameter.anonymousField((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))})).typeVariable("T").build();
        this.assertThat(biFunction).boundTo(RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER)), RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(biFunction).boundTo(RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER)), RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
    }

    @Test
    public void testVariadic() {
        Signature rowVariadicBoundFunction = TestSignatureBinder.functionSignature().returnType((Type)BigintType.BIGINT).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).variadicTypeParameter("T", "row").build();
        this.assertThat(rowVariadicBoundFunction).boundTo(RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))));
        this.assertThat(rowVariadicBoundFunction).boundTo(new ArrayType((Type)BigintType.BIGINT)).fails();
        this.assertThat(rowVariadicBoundFunction).boundTo(new ArrayType((Type)BigintType.BIGINT)).withCoercion().fails();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeVariableConstraint.builder((String)"T").variadicBound("array").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("variadicBound must be row but is array");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeVariableConstraint.builder((String)"T").variadicBound("map").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("variadicBound must be row but is map");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeVariableConstraint.builder((String)"T").variadicBound("decimal").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("variadicBound must be row but is decimal");
    }

    @Test
    public void testBindUnknownToVariadic() {
        Signature rowFunction = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).variadicTypeParameter("T", "row").build();
        this.assertThat(rowFunction).boundTo(UnknownType.UNKNOWN, RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT)))).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT)))));
    }

    @Test
    public void testInvalidVariadicBound() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeVariableConstraint.builder((String)"T").variadicBound("array").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("variadicBound must be row but is array");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeVariableConstraint.builder((String)"T").variadicBound("map").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("variadicBound must be row but is map");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeVariableConstraint.builder((String)"T").variadicBound("decimal").build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("variadicBound must be row but is decimal");
    }

    @Test
    public void testVarArgs() {
        Signature variableArityFunction = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).typeVariable("T").variableArity().build();
        this.assertThat(variableArityFunction).boundTo(BigintType.BIGINT).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(variableArityFunction).boundTo(VarcharType.VARCHAR).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)VarcharType.VARCHAR));
        this.assertThat(variableArityFunction).boundTo(BigintType.BIGINT, BigintType.BIGINT).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(variableArityFunction).boundTo(BigintType.BIGINT, VarcharType.VARCHAR).withCoercion().fails();
    }

    @Test
    public void testCoercion() {
        Signature function = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType((Type)DoubleType.DOUBLE).typeVariable("T").build();
        this.assertThat(function).boundTo(DoubleType.DOUBLE, DoubleType.DOUBLE).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)DoubleType.DOUBLE));
        this.assertThat(function).boundTo(BigintType.BIGINT, BigintType.BIGINT).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(function).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)VarcharType.VARCHAR));
        this.assertThat(function).boundTo(BigintType.BIGINT, VarcharType.VARCHAR).withCoercion().fails();
    }

    @Test
    public void testUnknownCoercion() {
        Signature foo = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).typeVariable("T").build();
        this.assertThat(foo).boundTo(UnknownType.UNKNOWN, UnknownType.UNKNOWN).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)UnknownType.UNKNOWN));
        this.assertThat(foo).boundTo(UnknownType.UNKNOWN, BigintType.BIGINT).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(foo).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).withCoercion().fails();
        Signature bar = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).comparableTypeParameter("T").build();
        this.assertThat(bar).boundTo(UnknownType.UNKNOWN, BigintType.BIGINT).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(bar).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).withCoercion().fails();
        this.assertThat(bar).boundTo(HyperLogLogType.HYPER_LOG_LOG, HyperLogLogType.HYPER_LOG_LOG).withCoercion().fails();
    }

    @Test
    public void testFunction() {
        Signature simple = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.functionType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature[])new TypeSignature[]{IntegerType.INTEGER.getTypeSignature()})).build();
        this.assertThat(simple).boundTo(IntegerType.INTEGER).fails();
        this.assertThat(simple).boundTo(new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER)).succeeds();
        this.assertThat(simple).boundTo(new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)SmallintType.SMALLINT)).withCoercion().fails();
        this.assertThat(simple).boundTo(new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)BigintType.BIGINT)).withCoercion().fails();
        Signature applyTwice = TestSignatureBinder.functionSignature().returnType(new TypeSignature("V", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("U", new TypeSignatureParameter[0])})).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("U", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("V", new TypeSignatureParameter[0])})).typeVariable("T").typeVariable("U").typeVariable("V").build();
        this.assertThat(applyTwice).boundTo(IntegerType.INTEGER, IntegerType.INTEGER, IntegerType.INTEGER).fails();
        this.assertThat(applyTwice).boundTo(IntegerType.INTEGER, new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR), new FunctionType((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE)).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)IntegerType.INTEGER).setTypeVariable("U", (Type)VarcharType.VARCHAR).setTypeVariable("V", (Type)DoubleType.DOUBLE));
        this.assertThat(applyTwice).boundTo(IntegerType.INTEGER, new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR).getTypeSignature()), new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE).getTypeSignature())).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)IntegerType.INTEGER).setTypeVariable("U", (Type)VarcharType.VARCHAR).setTypeVariable("V", (Type)DoubleType.DOUBLE));
        this.assertThat(applyTwice).boundTo(new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR).getTypeSignature()), new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR).getTypeSignature()), new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE).getTypeSignature())).fails();
        this.assertThat(applyTwice).boundTo(new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR).getTypeSignature()), IntegerType.INTEGER, new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE).getTypeSignature())).fails();
        Signature flatMap = TestSignatureBinder.functionSignature().returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))})).typeVariable("T").build();
        this.assertThat(flatMap).boundTo(new ArrayType((Type)IntegerType.INTEGER), new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)new ArrayType((Type)IntegerType.INTEGER))).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)IntegerType.INTEGER));
        Signature varargApply = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])})).typeVariable("T").variableArity().build();
        this.assertThat(varargApply).boundTo(IntegerType.INTEGER, new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER), new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER), new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER)).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)IntegerType.INTEGER));
        this.assertThat(varargApply).boundTo(IntegerType.INTEGER, new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER), new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)DoubleType.DOUBLE), new FunctionType((List)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)DoubleType.DOUBLE)).fails();
        Signature loop = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])})).typeVariable("T").build();
        this.assertThat(loop).boundTo(IntegerType.INTEGER, new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)BigintType.BIGINT).getTypeSignature())).fails();
        this.assertThat(loop).boundTo(IntegerType.INTEGER, new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)BigintType.BIGINT).getTypeSignature())).withCoercion().produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)BigintType.BIGINT));
        this.assertThat(loop).withCoercion().boundTo(IntegerType.INTEGER, new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)SmallintType.SMALLINT).getTypeSignature())).fails();
        Signature varcharApply = TestSignatureBinder.functionSignature().returnType((Type)VarcharType.VARCHAR).argumentType((Type)VarcharType.VARCHAR).argumentType(TypeSignature.functionType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature[])new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})})).build();
        this.assertThat(varcharApply).withCoercion().boundTo(VarcharType.createVarcharType((int)10), new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)VarcharType.createVarcharType((int)1)).getTypeSignature())).succeeds();
        Signature sortByKey = TestSignatureBinder.functionSignature().returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("E", new TypeSignatureParameter[0])})).typeVariable("T").orderableTypeParameter("E").build();
        this.assertThat(sortByKey).boundTo(new ArrayType((Type)IntegerType.INTEGER), new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)VarcharType.VARCHAR).getTypeSignature())).produces((TypeVariables)new BoundVariables().setTypeVariable("T", (Type)IntegerType.INTEGER).setTypeVariable("E", (Type)VarcharType.VARCHAR));
    }

    @Test
    public void testCanCoerceTo() {
        Signature arrayJoin = TestSignatureBinder.functionSignature().returnType((Type)VarcharType.VARCHAR).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).castableToTypeParameter("E", VarcharType.VARCHAR.getTypeSignature()).build();
        this.assertThat(arrayJoin).boundTo(new ArrayType((Type)IntegerType.INTEGER)).produces((TypeVariables)new BoundVariables().setTypeVariable("E", (Type)IntegerType.INTEGER));
        this.assertThat(arrayJoin).boundTo(new ArrayType((Type)VarbinaryType.VARBINARY)).fails();
        Signature castArray = TestSignatureBinder.functionSignature().returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("F", new TypeSignatureParameter[0]))).typeVariable("T").castableToTypeParameter("F", new TypeSignature("T", new TypeSignatureParameter[0])).build();
        this.assertThat(castArray).boundTo((List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER)), (Type)new ArrayType((Type)VarcharType.VARCHAR)).produces((TypeVariables)new BoundVariables().setTypeVariable("F", (Type)IntegerType.INTEGER).setTypeVariable("T", (Type)VarcharType.VARCHAR));
        this.assertThat(castArray).boundTo(new ArrayType((Type)IntegerType.INTEGER), new ArrayType((Type)TimestampType.TIMESTAMP_MILLIS)).fails();
        Signature multiCast = TestSignatureBinder.functionSignature().returnType((Type)VarcharType.VARCHAR).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).typeVariableConstraint(TypeVariableConstraint.builder((String)"E").castableTo((Type)VarcharType.VARCHAR).castableTo((Type)IntegerType.INTEGER).build()).build();
        this.assertThat(multiCast).boundTo(new ArrayType((Type)TinyintType.TINYINT)).produces((TypeVariables)new BoundVariables().setTypeVariable("E", (Type)TinyintType.TINYINT));
        this.assertThat(multiCast).boundTo(new ArrayType((Type)TimestampType.TIMESTAMP_MILLIS)).fails();
    }

    @Test
    public void testCanCoerceFrom() {
        Signature arrayJoin = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType(JsonType.JSON.getTypeSignature()).castableFromTypeParameter("E", JsonType.JSON.getTypeSignature()).build();
        this.assertThat(arrayJoin).boundTo(new ArrayType((Type)IntegerType.INTEGER), JsonType.JSON).produces((TypeVariables)new BoundVariables().setTypeVariable("E", (Type)IntegerType.INTEGER));
        this.assertThat(arrayJoin).boundTo(new ArrayType((Type)VarbinaryType.VARBINARY)).fails();
        Signature multiCast = TestSignatureBinder.functionSignature().returnType((Type)BooleanType.BOOLEAN).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType((Type)JsonType.JSON).typeVariableConstraint(TypeVariableConstraint.builder((String)"E").castableFrom((Type)VarcharType.VARCHAR).castableFrom((Type)JsonType.JSON).build()).build();
        this.assertThat(multiCast).boundTo(new ArrayType((Type)TinyintType.TINYINT), JsonType.JSON).produces((TypeVariables)new BoundVariables().setTypeVariable("E", (Type)TinyintType.TINYINT));
        this.assertThat(multiCast).boundTo(new ArrayType((Type)TimestampType.TIMESTAMP_MILLIS), JsonType.JSON).fails();
    }

    @Test
    public void testBindParameters() {
        BoundVariables boundVariables = new BoundVariables().setTypeVariable("T1", (Type)DoubleType.DOUBLE).setTypeVariable("T2", (Type)BigintType.BIGINT).setTypeVariable("T3", (Type)DecimalType.createDecimalType((int)5, (int)3)).setLongVariable("p", Long.valueOf(1L)).setLongVariable("s", Long.valueOf(2L));
        TestSignatureBinder.assertThat("bigint", (TypeVariables)boundVariables, "bigint");
        TestSignatureBinder.assertThat("T1", (TypeVariables)boundVariables, "double");
        TestSignatureBinder.assertThat("T2", (TypeVariables)boundVariables, "bigint");
        TestSignatureBinder.assertThat("array(T1)", (TypeVariables)boundVariables, "array(double)");
        TestSignatureBinder.assertThat("array(T3)", (TypeVariables)boundVariables, "array(decimal(5,3))");
        TestSignatureBinder.assertThat("map(T1,T2)", (TypeVariables)boundVariables, "map(double,bigint)");
        TestSignatureBinder.assertThat("bla(T1,42,T2)", (TypeVariables)boundVariables, "bla(double,42,bigint)");
        TestSignatureBinder.assertThat("varchar(p)", (TypeVariables)boundVariables, "varchar(1)");
        TestSignatureBinder.assertThat("char(p)", (TypeVariables)boundVariables, "char(1)");
        TestSignatureBinder.assertThat("decimal(p,s)", (TypeVariables)boundVariables, "decimal(1,2)");
        TestSignatureBinder.assertThat("array(decimal(p,s))", (TypeVariables)boundVariables, "array(decimal(1,2))");
        TestSignatureBinder.assertBindVariablesFails("T1(bigint)", (TypeVariables)boundVariables, "Unbounded parameters cannot have parameters");
    }

    private static void assertBindVariablesFails(String typeSignature, TypeVariables typeVariables, String reason) {
        try {
            SignatureBinder.applyBoundVariables((TypeSignature)TypeSignatureTranslator.parseTypeSignature((String)typeSignature, (Set)ImmutableSet.of((Object)"p", (Object)"s")), (TypeVariables)typeVariables);
            Fail.fail((String)reason);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void assertThat(String typeSignature, TypeVariables typeVariables, String expectedTypeSignature) {
        Assertions.assertThat((String)SignatureBinder.applyBoundVariables((TypeSignature)TypeSignatureTranslator.parseTypeSignature((String)typeSignature, (Set)ImmutableSet.of((Object)"p", (Object)"s")), (TypeVariables)typeVariables).toString()).isEqualTo(expectedTypeSignature);
    }

    private static Signature.Builder functionSignature() {
        return Signature.builder();
    }

    private Type type(TypeSignature signature) {
        return Objects.requireNonNull(TestingPlannerContext.PLANNER_CONTEXT.getTypeManager().getType(signature));
    }

    private BindSignatureAssertion assertThat(Signature function) {
        return new BindSignatureAssertion(function);
    }

    private static class BindSignatureAssertion {
        private final Signature function;
        private List<TypeSignatureProvider> argumentTypes;
        private Type returnType;
        private boolean allowCoercion;

        private BindSignatureAssertion(Signature function) {
            this.function = function;
        }

        public BindSignatureAssertion withCoercion() {
            this.allowCoercion = true;
            return this;
        }

        public BindSignatureAssertion boundTo(Object ... arguments) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object argument : arguments) {
                if (argument instanceof Type) {
                    Type type = (Type)argument;
                    builder.add((Object)new TypeSignatureProvider(type.getTypeSignature()));
                    continue;
                }
                if (argument instanceof TypeSignatureProvider) {
                    TypeSignatureProvider typeSignatureProvider = (TypeSignatureProvider)argument;
                    builder.add((Object)typeSignatureProvider);
                    continue;
                }
                throw new IllegalArgumentException(String.format("argument is of type %s. It should be Type or TypeSignatureProvider", argument.getClass()));
            }
            this.argumentTypes = builder.build();
            return this;
        }

        public BindSignatureAssertion boundTo(List<Type> arguments, Type returnType) {
            this.argumentTypes = TypeSignatureProvider.fromTypes(arguments);
            this.returnType = returnType;
            return this;
        }

        public BindSignatureAssertion succeeds() {
            Assertions.assertThat(this.bindVariables()).isPresent();
            return this;
        }

        public BindSignatureAssertion fails() {
            Assertions.assertThat(this.bindVariables()).isEmpty();
            return this;
        }

        public BindSignatureAssertion produces(TypeVariables expected) {
            Optional<TypeVariables> actual = this.bindVariables();
            Assertions.assertThat(actual).isPresent();
            Assertions.assertThat((Object)actual.get()).isEqualTo((Object)expected);
            return this;
        }

        private Optional<TypeVariables> bindVariables() {
            Assertions.assertThat(this.argumentTypes).isNotNull();
            SignatureBinder signatureBinder = new SignatureBinder(TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), TestingPlannerContext.PLANNER_CONTEXT.getTypeManager(), this.function, this.allowCoercion);
            if (this.returnType == null) {
                return signatureBinder.bindVariables(this.argumentTypes);
            }
            return signatureBinder.bindVariables(this.argumentTypes, this.returnType.getTypeSignature());
        }
    }
}

