/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.RowPagesBuilder;
import io.trino.jmh.Benchmarks;
import io.trino.operator.PagesIndex;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=2)
@Warmup(iterations=3)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
public class BenchmarkPagesIndexOrdering {
    private static final Random RANDOM = new Random(633969769L);
    private static final int ROWS_PER_PAGE = 1024;
    private static final int NUMBER_OF_PAGES = 128;

    @Benchmark
    public Object benchmarkQuickSort(Context context) {
        PagesIndex pagesIndex = new PagesIndex.TestingFactory(true).newPagesIndex(context.types, 131072);
        context.pages.forEach(arg_0 -> ((PagesIndex)pagesIndex).addPage(arg_0));
        pagesIndex.sort(context.sortChannels, context.sortOrders);
        return pagesIndex.getValueAddresses();
    }

    @Test
    public void testBenchmarkBuildHash() {
        Context context = new Context();
        context.setup();
        this.benchmarkQuickSort(context);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkPagesIndexOrdering.class).run();
    }

    @State(value=Scope.Benchmark)
    public static class Context {
        @Param(value={"1", "10"})
        protected int numberOfChannels = 1;
        private List<Type> types;
        private List<Integer> sortChannels;
        private List<SortOrder> sortOrders;
        private List<Page> pages;

        @Setup
        public void setup() {
            this.types = Collections.nCopies(this.numberOfChannels, BigintType.BIGINT);
            this.sortChannels = (List)IntStream.range(0, this.numberOfChannels).boxed().collect(ImmutableList.toImmutableList());
            this.sortOrders = Collections.nCopies(this.numberOfChannels, SortOrder.ASC_NULLS_FIRST);
            RowPagesBuilder pagesBuilder = RowPagesBuilder.rowPagesBuilder(this.types);
            for (int page = 0; page < 128; ++page) {
                for (int row = 0; row < 1024; ++row) {
                    Object[] values = new Object[this.numberOfChannels];
                    for (int channel = 0; channel < this.numberOfChannels; ++channel) {
                        values[channel] = RANDOM.nextLong();
                    }
                    pagesBuilder.row(values);
                }
                pagesBuilder.pageBreak();
            }
            this.pages = pagesBuilder.build();
        }
    }
}

