/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.ExceededMemoryLimitException;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.DummySpillerFactory;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.PositionSearcher;
import io.trino.operator.WindowFunctionDefinition;
import io.trino.operator.WindowOperator;
import io.trino.operator.window.FirstValueFunction;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.LagFunction;
import io.trino.operator.window.LastValueFunction;
import io.trino.operator.window.LeadFunction;
import io.trino.operator.window.NthValueFunction;
import io.trino.operator.window.PartitionerSupplier;
import io.trino.operator.window.RankFunction;
import io.trino.operator.window.ReflectionWindowFunctionSupplier;
import io.trino.operator.window.RegularPartitionerSupplier;
import io.trino.operator.window.RowNumberFunction;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.WindowFunctionSupplier;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.SpillerFactory;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestWindowOperator {
    private static final TypeOperators TYPE_OPERATORS_CACHE = new TypeOperators();
    private static final FrameInfo UNBOUNDED_FRAME = new FrameInfo(WindowFrameType.RANGE, FrameBoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public static final List<WindowFunctionDefinition> ROW_NUMBER = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier(0, RowNumberFunction.class), (Type)BigintType.BIGINT, (FrameInfo)UNBOUNDED_FRAME, (boolean)false, (List)ImmutableList.of(), (Integer[])new Integer[0]));
    public static final List<WindowFunctionDefinition> RANK = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier(0, RankFunction.class), (Type)BigintType.BIGINT, (FrameInfo)UNBOUNDED_FRAME, (boolean)false, (List)ImmutableList.of(), (Integer[])new Integer[0]));
    private static final List<WindowFunctionDefinition> FIRST_VALUE = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier(1, FirstValueFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (boolean)false, (List)ImmutableList.of(), (Integer[])new Integer[]{1}));
    private static final List<WindowFunctionDefinition> LAST_VALUE = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier(1, LastValueFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (boolean)false, (List)ImmutableList.of(), (Integer[])new Integer[]{1}));
    private static final List<WindowFunctionDefinition> NTH_VALUE = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier(2, NthValueFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (boolean)false, (List)ImmutableList.of(), (Integer[])new Integer[]{1, 3}));
    private static final List<WindowFunctionDefinition> LAG = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier(3, LagFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (boolean)false, (List)ImmutableList.of(), (Integer[])new Integer[]{1, 3, 4}));
    private static final List<WindowFunctionDefinition> LEAD = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier(3, LeadFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (boolean)false, (List)ImmutableList.of(), (Integer[])new Integer[]{1, 3, 4}));
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testMultipleOutputPages() {
        this.testMultipleOutputPages(false, false, 0L);
        this.testMultipleOutputPages(true, false, 8L);
        this.testMultipleOutputPages(true, true, 8L);
        this.testMultipleOutputPages(true, false, 0L);
        this.testMultipleOutputPages(true, true, 0L);
    }

    private void testMultipleOutputPages(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        DummySpillerFactory spillerFactory = new DummySpillerFactory();
        int numberOfRows = 80000;
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).addSequencePage(numberOfRows, 0, 0).build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[]{0}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.DESC_NULLS_FIRST}), spillerFactory, spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult.Builder expectedBuilder = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT});
        for (int i = 0; i < numberOfRows; ++i) {
            expectedBuilder.row(new Object[]{(double)numberOfRows - (double)i - 1.0, (long)numberOfRows - (long)i - 1L, (long)i + 1L});
        }
        MaterializedResult expected = expectedBuilder.build();
        List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input, revokeMemoryWhenAddingPages);
        ((ListAssert)Assertions.assertThat(pages).as("Expected more than one output page", new Object[0])).hasSizeGreaterThan(1);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), expected.getTypes(), pages);
        Assertions.assertThat((List)actual.getMaterializedRows()).isEqualTo((Object)expected.getMaterializedRows());
        ((AbstractBooleanAssert)Assertions.assertThat((spillEnabled == spillerFactory.getSpillsCount() > 0L ? 1 : 0) != 0).describedAs(String.format("Spill state mismatch. Expected spill: %s, spill count: %s", spillEnabled, spillerFactory.getSpillsCount()), new Object[0])).isTrue();
    }

    @Test
    public void testRowNumber() {
        this.testRowNumber(false, false, 0L);
        this.testRowNumber(true, false, 8L);
        this.testRowNumber(true, true, 8L);
        this.testRowNumber(true, false, 0L);
        this.testRowNumber(true, true, 0L);
    }

    private void testRowNumber(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(2L, 0.3).row(4L, 0.2).row(6L, 0.1).pageBreak().row(-1L, -0.1).row(5L, 0.4).build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[]{0}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{-0.1, -1L, 1L}).row(new Object[]{0.3, 2L, 2L}).row(new Object[]{0.2, 4L, 3L}).row(new Object[]{0.4, 5L, 4L}).row(new Object[]{0.1, 6L, 5L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testRowNumberPartition() {
        this.testRowNumberPartition(false, false, 0L);
        this.testRowNumberPartition(true, false, 8L);
        this.testRowNumberPartition(true, true, 8L);
        this.testRowNumberPartition(true, false, 0L);
        this.testRowNumberPartition(true, true, 0L);
    }

    private void testRowNumberPartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, DoubleType.DOUBLE, BooleanType.BOOLEAN}).row("b", -1L, -0.1, true).row("a", 2L, 0.3, false).row("a", 4L, 0.2, true).pageBreak().row("b", 5L, 0.4, false).row("a", 6L, 0.1, true).build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{1}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, DoubleType.DOUBLE, BooleanType.BOOLEAN, BigintType.BIGINT}).row(new Object[]{"a", 2L, 0.3, false, 1L}).row(new Object[]{"a", 4L, 0.2, true, 2L}).row(new Object[]{"a", 6L, 0.1, true, 3L}).row(new Object[]{"b", -1L, -0.1, true, 1L}).row(new Object[]{"b", 5L, 0.4, false, 2L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testRowNumberArbitrary() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(1L).row(3L).row(5L).row(7L).pageBreak().row(2L).row(4L).row(6L).row(8L).build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[0]), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[0]), new DummySpillerFactory(), false);
        DriverContext driverContext = this.createDriverContext();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 1L}).row(new Object[]{3L, 2L}).row(new Object[]{5L, 3L}).row(new Object[]{7L, 4L}).row(new Object[]{2L, 5L}).row(new Object[]{4L, 6L}).row(new Object[]{6L, 7L}).row(new Object[]{8L, 8L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected);
    }

    @Test
    public void testRowNumberArbitraryWithSpill() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(1L).row(3L).row(5L).row(7L).pageBreak().row(2L).row(4L).row(6L).row(8L).build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[0]), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[0]), new DummySpillerFactory(), true);
        DriverContext driverContext = this.createDriverContext();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).row(new Object[]{3L, 3L}).row(new Object[]{4L, 4L}).row(new Object[]{5L, 5L}).row(new Object[]{6L, 6L}).row(new Object[]{7L, 7L}).row(new Object[]{8L, 8L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected);
    }

    @Test
    public void testDistinctPartitionAndPeers() {
        this.testDistinctPartitionAndPeers(false, false, 0L);
        this.testDistinctPartitionAndPeers(true, false, 8L);
        this.testDistinctPartitionAndPeers(true, true, 8L);
        this.testDistinctPartitionAndPeers(true, false, 0L);
        this.testDistinctPartitionAndPeers(true, true, 0L);
    }

    public void testDistinctPartitionAndPeers(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}).row(1.0, 1.0).row(1.0, 0.0).row(1.0, Double.NaN).row(1.0, null).row(2.0, 2.0).row(2.0, Double.NaN).row(Double.NaN, Double.NaN).row(Double.NaN, Double.NaN).row(null, null).row(null, 1.0).row(null, null).pageBreak().row(1.0, Double.NaN).row(1.0, null).row(2.0, 2.0).row(2.0, null).row(Double.NaN, 3.0).row(Double.NaN, null).row(null, 2.0).row(null, null).build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{0, 1}), RANK, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{1}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{1.0, 0.0, 1L}).row(new Object[]{1.0, 1.0, 2L}).row(new Object[]{1.0, Double.NaN, 3L}).row(new Object[]{1.0, Double.NaN, 3L}).row(new Object[]{1.0, null, 5L}).row(new Object[]{1.0, null, 5L}).row(new Object[]{2.0, 2.0, 1L}).row(new Object[]{2.0, 2.0, 1L}).row(new Object[]{2.0, Double.NaN, 3L}).row(new Object[]{2.0, null, 4L}).row(new Object[]{Double.NaN, 3.0, 1L}).row(new Object[]{Double.NaN, Double.NaN, 2L}).row(new Object[]{Double.NaN, Double.NaN, 2L}).row(new Object[]{Double.NaN, null, 4L}).row(new Object[]{null, 1.0, 1L}).row(new Object[]{null, 2.0, 2L}).row(new Object[]{null, null, 3L}).row(new Object[]{null, null, 3L}).row(new Object[]{null, null, 3L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testMemoryLimit() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).build();
            DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.ofBytes((long)10L)).addPipelineContext(0, true, true, false).addDriverContext();
            WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[]{0}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), false);
            OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
        }).isInstanceOf(ExceededMemoryLimitException.class)).hasMessageMatching("Query exceeded per-node memory limit of 10B.*");
    }

    @Test
    public void testFirstValuePartition() {
        this.testFirstValuePartition(false, false, 0L);
        this.testFirstValuePartition(true, false, 8L);
        this.testFirstValuePartition(true, true, 8L);
        this.testFirstValuePartition(true, false, 0L);
        this.testFirstValuePartition(true, true, 0L);
    }

    private void testFirstValuePartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, true, "").row("a", "A2", 1L, false, "").row("a", "B1", 2L, true, "").pageBreak().row("b", "C1", 2L, false, "").row("a", "C2", 3L, true, "").row("c", "A3", 1L, true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), FIRST_VALUE, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "A2"}).row(new Object[]{"a", "B1", 2L, true, "A2"}).row(new Object[]{"a", "C2", 3L, true, "A2"}).row(new Object[]{"b", "A1", 1L, true, "A1"}).row(new Object[]{"b", "C1", 2L, false, "A1"}).row(new Object[]{"c", "A3", 1L, true, "A3"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testClose() throws Exception {
        int i;
        RowPagesBuilder pageBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT});
        for (i = 0; i < 500000; ++i) {
            pageBuilder.row("a", 0L);
        }
        for (i = 0; i < 500000; ++i) {
            pageBuilder.row("b", 0L);
        }
        List<Page> input = pageBuilder.build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0, 1}), ROW_NUMBER, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{1}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), false);
        DriverContext driverContext = this.createDriverContext(1000L);
        Operator operator = operatorFactory.createOperator(driverContext);
        operatorFactory.noMoreOperators();
        Assertions.assertThat((boolean)operator.isFinished()).isFalse();
        Assertions.assertThat((boolean)operator.needsInput()).isTrue();
        operator.addInput(input.get(0));
        operator.finish();
        operator.getOutput();
        operator.close();
    }

    @Test
    public void testLastValuePartition() {
        this.testLastValuePartition(false, false, 0L);
        this.testLastValuePartition(true, false, 8L);
        this.testLastValuePartition(true, true, 8L);
        this.testLastValuePartition(true, false, 0L);
        this.testLastValuePartition(true, true, 0L);
    }

    private void testLastValuePartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, true, "").row("a", "A2", 1L, false, "").row("a", "B1", 2L, true, "").pageBreak().row("b", "C1", 2L, false, "").row("a", "C2", 3L, true, "").row("c", "A3", 1L, true, "").build();
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), LAST_VALUE, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), spillEnabled);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "C2"}).row(new Object[]{"a", "B1", 2L, true, "C2"}).row(new Object[]{"a", "C2", 3L, true, "C2"}).row(new Object[]{"b", "A1", 1L, true, "C1"}).row(new Object[]{"b", "C1", 2L, false, "C1"}).row(new Object[]{"c", "A3", 1L, true, "A3"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testNthValuePartition() {
        this.testNthValuePartition(false, false, 0L);
        this.testNthValuePartition(true, false, 8L);
        this.testNthValuePartition(true, true, 8L);
        this.testNthValuePartition(true, false, 0L);
        this.testNthValuePartition(true, true, 0L);
    }

    private void testNthValuePartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, 2L, true, "").row("a", "A2", 1L, 3L, false, "").row("a", "B1", 2L, 2L, true, "").pageBreak().row("b", "C1", 2L, 3L, false, "").row("a", "C2", 3L, 1L, true, "").row("c", "A3", 1L, null, true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 4}), NTH_VALUE, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "C2"}).row(new Object[]{"a", "B1", 2L, true, "B1"}).row(new Object[]{"a", "C2", 3L, true, "A2"}).row(new Object[]{"b", "A1", 1L, true, "C1"}).row(new Object[]{"b", "C1", 2L, false, null}).row(new Object[]{"c", "A3", 1L, true, null}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testLagPartition() {
        this.testLagPartition(false, false, 0L);
        this.testLagPartition(true, false, 8L);
        this.testLagPartition(true, true, 8L);
        this.testLagPartition(true, false, 0L);
        this.testLagPartition(true, true, 0L);
    }

    private void testLagPartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, 1L, "D", true, "").row("a", "A2", 1L, 2L, "D", false, "").row("a", "B1", 2L, 2L, "D", true, "").pageBreak().row("b", "C1", 2L, 1L, "D", false, "").row("a", "C2", 3L, 2L, "D", true, "").row("c", "A3", 1L, 1L, "D", true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 5}), LAG, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "D"}).row(new Object[]{"a", "B1", 2L, true, "D"}).row(new Object[]{"a", "C2", 3L, true, "A2"}).row(new Object[]{"b", "A1", 1L, true, "D"}).row(new Object[]{"b", "C1", 2L, false, "A1"}).row(new Object[]{"c", "A3", 1L, true, "D"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testLeadPartition() {
        this.testLeadPartition(false, false, 0L);
        this.testLeadPartition(true, false, 8L);
        this.testLeadPartition(true, true, 8L);
        this.testLeadPartition(true, false, 0L);
        this.testLeadPartition(true, true, 0L);
    }

    private void testLeadPartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, 1L, "D", true, "").row("a", "A2", 1L, 2L, "D", false, "").row("a", "B1", 2L, 2L, "D", true, "").pageBreak().row("b", "C1", 2L, 1L, "D", false, "").row("a", "C2", 3L, 2L, "D", true, "").row("c", "A3", 1L, 1L, "D", true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 5}), LEAD, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "C2"}).row(new Object[]{"a", "B1", 2L, true, "D"}).row(new Object[]{"a", "C2", 3L, true, "D"}).row(new Object[]{"b", "A1", 1L, true, "C1"}).row(new Object[]{"b", "C1", 2L, false, "D"}).row(new Object[]{"c", "A3", 1L, true, "D"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testPartiallyPreGroupedPartitionWithEmptyInput() {
        this.testPartiallyPreGroupedPartitionWithEmptyInput(false, false, 0L);
        this.testPartiallyPreGroupedPartitionWithEmptyInput(true, false, 8L);
        this.testPartiallyPreGroupedPartitionWithEmptyInput(true, true, 8L);
        this.testPartiallyPreGroupedPartitionWithEmptyInput(true, false, 0L);
        this.testPartiallyPreGroupedPartitionWithEmptyInput(true, true, 0L);
    }

    private void testPartiallyPreGroupedPartitionWithEmptyInput(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().pageBreak().build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 0, new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testPartiallyPreGroupedPartition() {
        this.testPartiallyPreGroupedPartition(false, false, 0L);
        this.testPartiallyPreGroupedPartition(true, false, 8L);
        this.testPartiallyPreGroupedPartition(true, true, 8L);
        this.testPartiallyPreGroupedPartition(true, false, 0L);
        this.testPartiallyPreGroupedPartition(true, true, 0L);
    }

    private void testPartiallyPreGroupedPartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().row(1L, "a", 100L, "A").row(2L, "a", 101L, "B").pageBreak().row(3L, "b", 102L, "E").row(1L, "b", 103L, "D").pageBreak().row(3L, "b", 104L, "C").row(1L, "c", 105L, "F").pageBreak().build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 0, new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "a", 100L, "A", 1L}).row(new Object[]{2L, "a", 101L, "B", 1L}).row(new Object[]{3L, "b", 104L, "C", 1L}).row(new Object[]{3L, "b", 102L, "E", 2L}).row(new Object[]{1L, "b", 103L, "D", 1L}).row(new Object[]{1L, "c", 105L, "F", 1L}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testFullyPreGroupedPartition() {
        this.testFullyPreGroupedPartition(false, false, 0L);
        this.testFullyPreGroupedPartition(true, false, 8L);
        this.testFullyPreGroupedPartition(true, true, 8L);
        this.testFullyPreGroupedPartition(true, false, 0L);
        this.testFullyPreGroupedPartition(true, true, 0L);
    }

    private void testFullyPreGroupedPartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().row(1L, "a", 100L, "A").pageBreak().row(2L, "a", 101L, "B").pageBreak().row(2L, "b", 102L, "D").row(2L, "b", 103L, "C").row(1L, "b", 104L, "E").pageBreak().row(1L, "b", 105L, "F").row(3L, "c", 106L, "G").build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 0, new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "a", 100L, "A", 1L}).row(new Object[]{2L, "a", 101L, "B", 1L}).row(new Object[]{2L, "b", 103L, "C", 1L}).row(new Object[]{2L, "b", 102L, "D", 2L}).row(new Object[]{1L, "b", 104L, "E", 1L}).row(new Object[]{1L, "b", 105L, "F", 2L}).row(new Object[]{3L, "c", 106L, "G", 1L}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testFullyPreGroupedAndPartiallySortedPartition() {
        this.testFullyPreGroupedAndPartiallySortedPartition(false, false, 0L);
        this.testFullyPreGroupedAndPartiallySortedPartition(true, false, 8L);
        this.testFullyPreGroupedAndPartiallySortedPartition(true, true, 8L);
        this.testFullyPreGroupedAndPartiallySortedPartition(true, false, 0L);
        this.testFullyPreGroupedAndPartiallySortedPartition(true, true, 0L);
    }

    private void testFullyPreGroupedAndPartiallySortedPartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().row(1L, "a", 100L, "A").pageBreak().row(2L, "a", 100L, "A").pageBreak().row(2L, "b", 102L, "A").row(2L, "b", 101L, "A").row(2L, "b", 100L, "B").row(1L, "b", 101L, "A").pageBreak().row(1L, "b", 100L, "A").row(3L, "c", 100L, "A").build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{3, 2}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST, (Object)SortOrder.ASC_NULLS_LAST), 1, new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "a", 100L, "A", 1L}).row(new Object[]{2L, "a", 100L, "A", 1L}).row(new Object[]{2L, "b", 101L, "A", 1L}).row(new Object[]{2L, "b", 102L, "A", 2L}).row(new Object[]{2L, "b", 100L, "B", 3L}).row(new Object[]{1L, "b", 100L, "A", 1L}).row(new Object[]{1L, "b", 101L, "A", 2L}).row(new Object[]{3L, "c", 100L, "A", 1L}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testFullyPreGroupedAndFullySortedPartition() {
        this.testFullyPreGroupedAndFullySortedPartition(false, false, 0L);
        this.testFullyPreGroupedAndFullySortedPartition(true, false, 8L);
        this.testFullyPreGroupedAndFullySortedPartition(true, true, 8L);
        this.testFullyPreGroupedAndFullySortedPartition(true, false, 0L);
        this.testFullyPreGroupedAndFullySortedPartition(true, true, 0L);
    }

    private void testFullyPreGroupedAndFullySortedPartition(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().row(1L, "a", 100L, "A").pageBreak().row(2L, "a", 101L, "A").pageBreak().row(2L, "b", 102L, "A").row(2L, "b", 103L, "A").row(2L, "b", 104L, "B").row(1L, "b", 105L, "A").pageBreak().row(1L, "b", 106L, "A").row(3L, "c", 107L, "A").build();
        WindowOperator.WindowOperatorFactory operatorFactory = this.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 1, new DummySpillerFactory(), spillEnabled);
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "a", 100L, "A", 1L}).row(new Object[]{2L, "a", 101L, "A", 1L}).row(new Object[]{2L, "b", 102L, "A", 1L}).row(new Object[]{2L, "b", 103L, "A", 2L}).row(new Object[]{2L, "b", 104L, "B", 3L}).row(new Object[]{1L, "b", 105L, "A", 1L}).row(new Object[]{1L, "b", 106L, "A", 2L}).row(new Object[]{3L, "c", 107L, "A", 1L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testFindEndPosition() {
        TestWindowOperator.assertFindEndPosition("0", 1);
        TestWindowOperator.assertFindEndPosition("11", 2);
        TestWindowOperator.assertFindEndPosition("1111111111", 10);
        TestWindowOperator.assertFindEndPosition("01", 1);
        TestWindowOperator.assertFindEndPosition("011", 1);
        TestWindowOperator.assertFindEndPosition("0111", 1);
        TestWindowOperator.assertFindEndPosition("0111111111", 1);
        TestWindowOperator.assertFindEndPosition("012", 1);
        TestWindowOperator.assertFindEndPosition("01234", 1);
        TestWindowOperator.assertFindEndPosition("0123456789", 1);
        TestWindowOperator.assertFindEndPosition("001", 2);
        TestWindowOperator.assertFindEndPosition("0001", 3);
        TestWindowOperator.assertFindEndPosition("0000000001", 9);
        TestWindowOperator.assertFindEndPosition("000111", 3);
        TestWindowOperator.assertFindEndPosition("0001111", 3);
        TestWindowOperator.assertFindEndPosition("0000111", 4);
        TestWindowOperator.assertFindEndPosition("000000000000001111111111", 14);
    }

    private static void assertFindEndPosition(String values, int expected) {
        char[] array = values.toCharArray();
        Assertions.assertThat((int)PositionSearcher.findEndPosition((int)0, (int)array.length, (first, second) -> array[first] == array[second])).isEqualTo(expected);
    }

    private WindowOperator.WindowOperatorFactory createFactoryUnbounded(List<? extends Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> functions, List<Integer> partitionChannels, List<Integer> sortChannels, List<SortOrder> sortOrder, SpillerFactory spillerFactory, boolean spillEnabled) {
        return TestWindowOperator.createFactoryUnbounded(sourceTypes, outputChannels, functions, partitionChannels, (List<Integer>)ImmutableList.of(), sortChannels, sortOrder, 0, spillerFactory, spillEnabled);
    }

    private WindowOperator.WindowOperatorFactory createFactoryUnbounded(List<? extends Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> functions, List<Integer> partitionChannels, List<Integer> preGroupedChannels, List<Integer> sortChannels, List<SortOrder> sortOrder, int preSortedChannelPrefix, DummySpillerFactory spillerFactory, boolean spillEnabled) {
        return new WindowOperator.WindowOperatorFactory(0, new PlanNodeId("test"), sourceTypes, outputChannels, functions, partitionChannels, preGroupedChannels, sortChannels, sortOrder, preSortedChannelPrefix, 10, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), spillEnabled, (SpillerFactory)spillerFactory, new OrderingCompiler(TYPE_OPERATORS_CACHE), (List)ImmutableList.of(), (PartitionerSupplier)new RegularPartitionerSupplier());
    }

    public static WindowOperator.WindowOperatorFactory createFactoryUnbounded(List<? extends Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> functions, List<Integer> partitionChannels, List<Integer> preGroupedChannels, List<Integer> sortChannels, List<SortOrder> sortOrder, int preSortedChannelPrefix, SpillerFactory spillerFactory, boolean spillEnabled) {
        return new WindowOperator.WindowOperatorFactory(0, new PlanNodeId("test"), sourceTypes, outputChannels, functions, partitionChannels, preGroupedChannels, sortChannels, sortOrder, preSortedChannelPrefix, 10, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), spillEnabled, spillerFactory, new OrderingCompiler(TYPE_OPERATORS_CACHE), (List)ImmutableList.of(), (PartitionerSupplier)new RegularPartitionerSupplier());
    }

    private DriverContext createDriverContext() {
        return this.createDriverContext(Long.MAX_VALUE);
    }

    private DriverContext createDriverContext(long memoryLimit) {
        return TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(DataSize.succinctBytes((long)memoryLimit)).build().addPipelineContext(0, true, true, false).addDriverContext();
    }
}

