/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.primitives.Ints;
import io.trino.RowPageBuilder;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.AggregationMetrics;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.GroupedAggregator;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.operator.aggregation.groupby.AggregationTestInput;
import io.trino.operator.aggregation.groupby.AggregationTestInputBuilder;
import io.trino.operator.aggregation.groupby.AggregationTestOutput;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.util.StructuralTestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMultimapAggAggregation {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    @Test
    public void testSingleValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a"));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L));
    }

    @Test
    public void testMultiValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)1.0, (Object)1.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)1.0, (Object)2.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
    }

    @Test
    public void testOrderValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)1L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)3L, (Object)2L, (Object)1L));
    }

    @Test
    public void testDuplicateValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L, (Object)1L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"a", (Object)"b", (Object)"c"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L, (Object)1L, (Object)1L, (Object)1L));
    }

    @Test
    public void testNullMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of(), (Type)VarcharType.VARCHAR, ImmutableList.of());
    }

    @Test
    public void testKeysUseIsDistinctSemantics() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)Double.NaN, (Object)Double.NaN), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)Double.NaN, (Object)Double.NaN, (Object)Double.NaN), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)1L, (Object)2L));
    }

    @Test
    public void testDoubleMapMultimap() {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        ImmutableList expectedKeys = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        ImmutableList expectedValues = ImmutableList.of((Object)ImmutableMap.of((Object)"a", (Object)1L), (Object)ImmutableMap.of((Object)"b", (Object)2L, (Object)"c", (Object)3L, (Object)"d", (Object)4L), (Object)ImmutableMap.of((Object)"a", (Object)1L));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, expectedKeys, (Type)mapType, expectedValues);
    }

    @Test
    public void testDoubleArrayMultimap() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        ImmutableList expectedKeys = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        ImmutableList expectedValues = ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, expectedKeys, (Type)arrayType, expectedValues);
    }

    @Test
    public void testDoubleRowMap() {
        RowType innerRowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"f1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), (Type)innerRowType, ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)1.0), (Object)ImmutableList.of((Object)2L, (Object)2.0), (Object)ImmutableList.of((Object)3L, (Object)3.0)));
    }

    @Test
    public void testMultiplePages() {
        TestingAggregationFunction aggFunction = TestMultimapAggAggregation.getAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAggregator groupedAggregator = aggFunction.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)0, (Object)1), OptionalInt.empty()).createGroupedAggregator(new AggregationMetrics());
        TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAggregator, 0, (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)3L));
    }

    @Test
    public void testMultiplePagesAndGroups() {
        TestingAggregationFunction aggFunction = TestMultimapAggAggregation.getAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAggregator groupedAggregator = aggFunction.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)0, (Object)1), OptionalInt.empty()).createGroupedAggregator(new AggregationMetrics());
        TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAggregator, 0, (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAggregator, 300, (Type)BigintType.BIGINT, ImmutableList.of((Object)7L, (Object)7L), (Type)BigintType.BIGINT, ImmutableList.of((Object)8L, (Object)9L));
    }

    @Test
    public void testManyValues() {
        TestingAggregationFunction aggFunction = TestMultimapAggAggregation.getAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAggregator groupedAggregator = aggFunction.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)0, (Object)1), OptionalInt.empty()).createGroupedAggregator(new AggregationMetrics());
        int numGroups = 30000;
        int numKeys = 10;
        int numValueArraySize = 2;
        Random random = new Random();
        for (int group = 0; group < numGroups; ++group) {
            ImmutableList.Builder keyBuilder = ImmutableList.builder();
            ImmutableList.Builder valueBuilder = ImmutableList.builder();
            for (int i = 0; i < numKeys; ++i) {
                long key = random.nextLong();
                for (int j = 0; j < numValueArraySize; ++j) {
                    long value = random.nextLong();
                    keyBuilder.add((Object)key);
                    valueBuilder.add((Object)value);
                }
            }
            TestMultimapAggAggregation.testMultimapAggWithGroupBy(aggFunction, groupedAggregator, group, (Type)BigintType.BIGINT, keyBuilder.build(), (Type)BigintType.BIGINT, valueBuilder.build());
        }
    }

    @Test
    public void testEmptyStateOutputIsNull() {
        TestingAggregationFunction aggregationFunction = TestMultimapAggAggregation.getAggregationFunction((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        GroupedAggregator groupedAggregator = aggregationFunction.createAggregatorFactory(AggregationNode.Step.SINGLE, Ints.asList((int[])new int[0]), OptionalInt.empty()).createGroupedAggregator(new AggregationMetrics());
        BlockBuilder blockBuilder = aggregationFunction.getFinalType().createBlockBuilder(null, 1);
        groupedAggregator.evaluate(0, blockBuilder);
        Assertions.assertThat((boolean)blockBuilder.build().isNull(0)).isTrue();
    }

    private static TestingAggregationFunction getAggregationFunction(Type keyType, Type valueType) {
        return FUNCTION_RESOLUTION.getAggregateFunction("multimap_agg", TypeSignatureProvider.fromTypes((Type[])new Type[]{keyType, valueType}));
    }

    private static <K, V> void testMultimapAgg(Type keyType, List<K> expectedKeys, Type valueType, List<V> expectedValues) {
        Preconditions.checkState((expectedKeys.size() == expectedValues.size() ? 1 : 0) != 0, (Object)"expectedKeys and expectedValues should have equal size");
        HashMap map = new HashMap();
        for (int i = 0; i < expectedKeys.size(); ++i) {
            if (!map.containsKey(expectedKeys.get(i))) {
                map.put(expectedKeys.get(i), new ArrayList());
            }
            ((List)map.get(expectedKeys.get(i))).add(expectedValues.get(i));
        }
        RowPageBuilder builder = RowPageBuilder.rowPageBuilder(keyType, valueType);
        for (int i = 0; i < expectedKeys.size(); ++i) {
            builder.row(expectedKeys.get(i), expectedValues.get(i));
        }
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "multimap_agg", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{keyType, valueType}), map.isEmpty() ? null : map, builder.build());
    }

    private static <K, V> void testMultimapAggWithGroupBy(TestingAggregationFunction aggregationFunction, GroupedAggregator groupedAggregator, int groupId, Type keyType, List<K> expectedKeys, Type valueType, List<V> expectedValues) {
        RowPageBuilder pageBuilder = RowPageBuilder.rowPageBuilder(keyType, valueType);
        ImmutableMultimap.Builder outputBuilder = ImmutableMultimap.builder();
        for (int i = 0; i < expectedValues.size(); ++i) {
            pageBuilder.row(expectedKeys.get(i), expectedValues.get(i));
            outputBuilder.put(expectedKeys.get(i), expectedValues.get(i));
        }
        Page page = pageBuilder.build();
        AggregationTestInput input = new AggregationTestInputBuilder(new Block[]{page.getBlock(0), page.getBlock(1)}, aggregationFunction).build();
        AggregationTestOutput testOutput = new AggregationTestOutput(outputBuilder.build().asMap());
        input.runPagesOnAggregatorWithAssertion(groupId, aggregationFunction.getFinalType(), groupedAggregator, testOutput);
    }
}

