/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.airlift.stats.QuantileDigest;
import io.trino.operator.aggregation.FloatingPointBitsConverterUtil;
import io.trino.spi.type.SqlVarbinary;
import io.trino.sql.query.QueryAssertions;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestQuantileDigestFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testQuantileAtValueBigint() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        TestQuantileDigestFunctions.addAll(qdigest, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(bigint)), 20)").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isNull();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(bigint)), 6)").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isEqualTo(0.6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(bigint)), -1)").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isNull();
    }

    @Test
    public void testQuantileAtValueDouble() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        IntStream.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9).mapToLong(FloatingPointBitsConverterUtil::doubleToSortableLong).forEach(arg_0 -> ((QuantileDigest)qdigest).add(arg_0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(double)), 5.6)").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isEqualTo(0.6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(double)), -1.23)").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isNull();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(double)), 12.3)").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isNull();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(double)), nan())").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isNull();
    }

    @Test
    public void testQuantileAtValueBigintWithEmptyDigest() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(bigint)), 5)").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isNull();
    }

    @Test
    public void testQuantileRoundTrip() {
        QuantileDigest qdigest = new QuantileDigest(1.0);
        TestQuantileDigestFunctions.addAll(qdigest, 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value_at_quantile(CAST(a AS qdigest(bigint)), quantile_at_value(CAST(a AS qdigest(bigint)), 6))").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(bigint)), value_at_quantile(CAST(a AS qdigest(bigint)), .6))").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isEqualTo(0.6);
        qdigest = new QuantileDigest(1.0);
        IntStream.range(0, 10).mapToLong(FloatingPointBitsConverterUtil::doubleToSortableLong).forEach(arg_0 -> ((QuantileDigest)qdigest).add(arg_0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value_at_quantile(CAST(a AS qdigest(double)),quantile_at_value(CAST(a AS qdigest(double)), 5.6))").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isEqualTo(6.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("quantile_at_value(CAST(a AS qdigest(double)),value_at_quantile(CAST(a AS qdigest(double)), .6))").binding("a", "X'%s'".formatted(TestQuantileDigestFunctions.toHexString(qdigest)))))).isEqualTo(0.6);
    }

    private static void addAll(QuantileDigest digest, long ... values) {
        for (long value : values) {
            digest.add(value);
        }
    }

    private static String toHexString(QuantileDigest qdigest) {
        return new SqlVarbinary(qdigest.serialize().getBytes()).toHexString().replaceAll("\\s+", " ");
    }
}

