/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.RowPagesBuilder;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.SimplePagesHashStrategy;
import io.trino.operator.SyntheticAddress;
import io.trino.operator.join.ArrayPositionLinks;
import io.trino.operator.join.JoinFilterFunction;
import io.trino.operator.join.PositionLinks;
import io.trino.operator.join.SortedPositionLinks;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPositionLinks {
    private static final Page TEST_PAGE = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(20, 0).build());

    @Test
    public void testArrayPositionLinks() {
        ArrayPositionLinks.FactoryBuilder factoryBuilder = ArrayPositionLinks.builder((int)1000);
        Assertions.assertThat((int)factoryBuilder.link(1, 0)).isEqualTo(1);
        Assertions.assertThat((int)factoryBuilder.link(2, 1)).isEqualTo(2);
        Assertions.assertThat((int)factoryBuilder.link(3, 2)).isEqualTo(3);
        Assertions.assertThat((int)factoryBuilder.link(11, 10)).isEqualTo(11);
        Assertions.assertThat((int)factoryBuilder.link(12, 11)).isEqualTo(12);
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of());
        Assertions.assertThat((int)positionLinks.start(3, 0, TEST_PAGE)).isEqualTo(3);
        Assertions.assertThat((int)positionLinks.next(3, 0, TEST_PAGE)).isEqualTo(2);
        Assertions.assertThat((int)positionLinks.next(2, 0, TEST_PAGE)).isEqualTo(1);
        Assertions.assertThat((int)positionLinks.next(1, 0, TEST_PAGE)).isEqualTo(0);
        Assertions.assertThat((int)positionLinks.start(4, 0, TEST_PAGE)).isEqualTo(4);
        Assertions.assertThat((int)positionLinks.next(4, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(12, 0, TEST_PAGE)).isEqualTo(12);
        Assertions.assertThat((int)positionLinks.next(12, 0, TEST_PAGE)).isEqualTo(11);
        Assertions.assertThat((int)positionLinks.next(11, 0, TEST_PAGE)).isEqualTo(10);
    }

    @Test
    public void testSortedPositionLinks() {
        JoinFilterFunction filterFunction = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(TEST_PAGE.getBlock(0), leftAddress) > 4L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunction));
        Assertions.assertThat((int)positionLinks.start(0, 0, TEST_PAGE)).isEqualTo(5);
        Assertions.assertThat((int)positionLinks.next(5, 0, TEST_PAGE)).isEqualTo(6);
        Assertions.assertThat((int)positionLinks.next(6, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(7, 0, TEST_PAGE)).isEqualTo(7);
        Assertions.assertThat((int)positionLinks.next(7, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(8, 0, TEST_PAGE)).isEqualTo(8);
        Assertions.assertThat((int)positionLinks.next(8, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(9, 0, TEST_PAGE)).isEqualTo(9);
        Assertions.assertThat((int)positionLinks.next(9, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(10, 0, TEST_PAGE)).isEqualTo(10);
        Assertions.assertThat((int)positionLinks.next(10, 0, TEST_PAGE)).isEqualTo(11);
        Assertions.assertThat((int)positionLinks.next(11, 0, TEST_PAGE)).isEqualTo(12);
        Assertions.assertThat((int)positionLinks.next(12, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(13, 0, TEST_PAGE)).isEqualTo(13);
        Assertions.assertThat((int)positionLinks.next(13, 0, TEST_PAGE)).isEqualTo(-1);
    }

    @Test
    public void testSortedPositionLinksAllMatch() {
        JoinFilterFunction filterFunction = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) >= 0L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunction));
        Assertions.assertThat((int)positionLinks.start(0, 0, TEST_PAGE)).isEqualTo(0);
        Assertions.assertThat((int)positionLinks.next(0, 0, TEST_PAGE)).isEqualTo(1);
        Assertions.assertThat((int)positionLinks.next(1, 0, TEST_PAGE)).isEqualTo(2);
        Assertions.assertThat((int)positionLinks.next(2, 0, TEST_PAGE)).isEqualTo(3);
        Assertions.assertThat((int)positionLinks.next(3, 0, TEST_PAGE)).isEqualTo(4);
        Assertions.assertThat((int)positionLinks.next(4, 0, TEST_PAGE)).isEqualTo(5);
        Assertions.assertThat((int)positionLinks.next(5, 0, TEST_PAGE)).isEqualTo(6);
        Assertions.assertThat((int)positionLinks.next(6, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(7, 0, TEST_PAGE)).isEqualTo(7);
        Assertions.assertThat((int)positionLinks.next(7, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(8, 0, TEST_PAGE)).isEqualTo(8);
        Assertions.assertThat((int)positionLinks.next(8, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(9, 0, TEST_PAGE)).isEqualTo(9);
        Assertions.assertThat((int)positionLinks.next(9, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(10, 0, TEST_PAGE)).isEqualTo(10);
        Assertions.assertThat((int)positionLinks.next(10, 0, TEST_PAGE)).isEqualTo(11);
        Assertions.assertThat((int)positionLinks.next(11, 0, TEST_PAGE)).isEqualTo(12);
        Assertions.assertThat((int)positionLinks.next(12, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(13, 0, TEST_PAGE)).isEqualTo(13);
        Assertions.assertThat((int)positionLinks.next(13, 0, TEST_PAGE)).isEqualTo(-1);
    }

    @Test
    public void testSortedPositionLinksForRangePredicates() {
        JoinFilterFunction filterFunctionOne = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(TEST_PAGE.getBlock(0), leftAddress) > 4L;
        JoinFilterFunction filterFunctionTwo = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(TEST_PAGE.getBlock(0), leftAddress) <= 11L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunctionOne, (Object)filterFunctionTwo));
        Assertions.assertThat((int)positionLinks.start(0, 0, TEST_PAGE)).isEqualTo(5);
        Assertions.assertThat((int)positionLinks.next(4, 0, TEST_PAGE)).isEqualTo(5);
        Assertions.assertThat((int)positionLinks.next(5, 0, TEST_PAGE)).isEqualTo(6);
        Assertions.assertThat((int)positionLinks.next(6, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(7, 0, TEST_PAGE)).isEqualTo(7);
        Assertions.assertThat((int)positionLinks.next(7, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(8, 0, TEST_PAGE)).isEqualTo(8);
        Assertions.assertThat((int)positionLinks.next(8, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(9, 0, TEST_PAGE)).isEqualTo(9);
        Assertions.assertThat((int)positionLinks.next(9, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(10, 0, TEST_PAGE)).isEqualTo(10);
        Assertions.assertThat((int)positionLinks.next(10, 0, TEST_PAGE)).isEqualTo(11);
        Assertions.assertThat((int)positionLinks.next(11, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(13, 0, TEST_PAGE)).isEqualTo(-1);
    }

    @Test
    public void testSortedPositionLinksForRangePredicatesPrefixMatch() {
        JoinFilterFunction filterFunctionOne = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) >= 0L;
        JoinFilterFunction filterFunctionTwo = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) <= 11L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunctionOne, (Object)filterFunctionTwo));
        Assertions.assertThat((int)positionLinks.start(0, 0, TEST_PAGE)).isEqualTo(0);
        Assertions.assertThat((int)positionLinks.next(0, 0, TEST_PAGE)).isEqualTo(1);
        Assertions.assertThat((int)positionLinks.next(1, 0, TEST_PAGE)).isEqualTo(2);
        Assertions.assertThat((int)positionLinks.next(2, 0, TEST_PAGE)).isEqualTo(3);
        Assertions.assertThat((int)positionLinks.next(3, 0, TEST_PAGE)).isEqualTo(4);
        Assertions.assertThat((int)positionLinks.next(4, 0, TEST_PAGE)).isEqualTo(5);
        Assertions.assertThat((int)positionLinks.next(5, 0, TEST_PAGE)).isEqualTo(6);
        Assertions.assertThat((int)positionLinks.next(6, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(7, 0, TEST_PAGE)).isEqualTo(7);
        Assertions.assertThat((int)positionLinks.next(7, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(8, 0, TEST_PAGE)).isEqualTo(8);
        Assertions.assertThat((int)positionLinks.next(8, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(9, 0, TEST_PAGE)).isEqualTo(9);
        Assertions.assertThat((int)positionLinks.next(9, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(10, 0, TEST_PAGE)).isEqualTo(10);
        Assertions.assertThat((int)positionLinks.next(10, 0, TEST_PAGE)).isEqualTo(11);
        Assertions.assertThat((int)positionLinks.next(11, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(13, 0, TEST_PAGE)).isEqualTo(-1);
    }

    @Test
    public void testSortedPositionLinksForRangePredicatesSuffixMatch() {
        JoinFilterFunction filterFunctionOne = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) > 4L;
        JoinFilterFunction filterFunctionTwo = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) < 100L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunctionOne, (Object)filterFunctionTwo));
        Assertions.assertThat((int)positionLinks.start(0, 0, TEST_PAGE)).isEqualTo(5);
        Assertions.assertThat((int)positionLinks.next(4, 0, TEST_PAGE)).isEqualTo(5);
        Assertions.assertThat((int)positionLinks.next(5, 0, TEST_PAGE)).isEqualTo(6);
        Assertions.assertThat((int)positionLinks.next(6, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(7, 0, TEST_PAGE)).isEqualTo(7);
        Assertions.assertThat((int)positionLinks.next(7, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(8, 0, TEST_PAGE)).isEqualTo(8);
        Assertions.assertThat((int)positionLinks.next(8, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(9, 0, TEST_PAGE)).isEqualTo(9);
        Assertions.assertThat((int)positionLinks.next(9, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(10, 0, TEST_PAGE)).isEqualTo(10);
        Assertions.assertThat((int)positionLinks.next(10, 0, TEST_PAGE)).isEqualTo(11);
        Assertions.assertThat((int)positionLinks.next(11, 0, TEST_PAGE)).isEqualTo(12);
        Assertions.assertThat((int)positionLinks.next(12, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(13, 0, TEST_PAGE)).isEqualTo(13);
        Assertions.assertThat((int)positionLinks.next(13, 0, TEST_PAGE)).isEqualTo(-1);
    }

    @Test
    public void testReverseSortedPositionLinks() {
        JoinFilterFunction filterFunction = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(TEST_PAGE.getBlock(0), leftAddress) < 4L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunction));
        Assertions.assertThat((int)positionLinks.start(0, 0, TEST_PAGE)).isEqualTo(0);
        Assertions.assertThat((int)positionLinks.next(0, 0, TEST_PAGE)).isEqualTo(1);
        Assertions.assertThat((int)positionLinks.next(1, 0, TEST_PAGE)).isEqualTo(2);
        Assertions.assertThat((int)positionLinks.next(2, 0, TEST_PAGE)).isEqualTo(3);
        Assertions.assertThat((int)positionLinks.next(3, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(10, 0, TEST_PAGE)).isEqualTo(-1);
    }

    @Test
    public void testReverseSortedPositionLinksAllMatch() {
        JoinFilterFunction filterFunction = (leftAddress, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), leftAddress) < 13L;
        PositionLinks.FactoryBuilder factoryBuilder = TestPositionLinks.buildSortedPositionLinks();
        PositionLinks positionLinks = factoryBuilder.build().create((List)ImmutableList.of((Object)filterFunction));
        Assertions.assertThat((int)positionLinks.start(0, 0, TEST_PAGE)).isEqualTo(0);
        Assertions.assertThat((int)positionLinks.next(0, 0, TEST_PAGE)).isEqualTo(1);
        Assertions.assertThat((int)positionLinks.next(1, 0, TEST_PAGE)).isEqualTo(2);
        Assertions.assertThat((int)positionLinks.next(2, 0, TEST_PAGE)).isEqualTo(3);
        Assertions.assertThat((int)positionLinks.next(3, 0, TEST_PAGE)).isEqualTo(4);
        Assertions.assertThat((int)positionLinks.next(4, 0, TEST_PAGE)).isEqualTo(5);
        Assertions.assertThat((int)positionLinks.next(5, 0, TEST_PAGE)).isEqualTo(6);
        Assertions.assertThat((int)positionLinks.next(6, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(7, 0, TEST_PAGE)).isEqualTo(7);
        Assertions.assertThat((int)positionLinks.next(7, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(8, 0, TEST_PAGE)).isEqualTo(8);
        Assertions.assertThat((int)positionLinks.next(8, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(9, 0, TEST_PAGE)).isEqualTo(9);
        Assertions.assertThat((int)positionLinks.next(9, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(10, 0, TEST_PAGE)).isEqualTo(10);
        Assertions.assertThat((int)positionLinks.next(10, 0, TEST_PAGE)).isEqualTo(11);
        Assertions.assertThat((int)positionLinks.next(11, 0, TEST_PAGE)).isEqualTo(12);
        Assertions.assertThat((int)positionLinks.next(12, 0, TEST_PAGE)).isEqualTo(-1);
        Assertions.assertThat((int)positionLinks.start(13, 0, TEST_PAGE)).isEqualTo(-1);
    }

    private static PositionLinks.FactoryBuilder buildSortedPositionLinks() {
        SortedPositionLinks.FactoryBuilder builder = SortedPositionLinks.builder((int)1000, (PagesHashStrategy)TestPositionLinks.pagesHashStrategy(), (LongArrayList)TestPositionLinks.addresses());
        Assertions.assertThat((int)builder.link(4, 5)).isEqualTo(4);
        Assertions.assertThat((int)builder.link(6, 4)).isEqualTo(4);
        Assertions.assertThat((int)builder.link(2, 4)).isEqualTo(2);
        Assertions.assertThat((int)builder.link(3, 2)).isEqualTo(2);
        Assertions.assertThat((int)builder.link(0, 2)).isEqualTo(0);
        Assertions.assertThat((int)builder.link(1, 0)).isEqualTo(0);
        Assertions.assertThat((int)builder.link(10, 11)).isEqualTo(10);
        Assertions.assertThat((int)builder.link(12, 10)).isEqualTo(10);
        return builder;
    }

    private static PagesHashStrategy pagesHashStrategy() {
        return new SimplePagesHashStrategy((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new ObjectArrayList((Collection)ImmutableList.of((Object)TEST_PAGE.getBlock(0)))), (List)ImmutableList.of(), OptionalInt.empty(), Optional.of(0), new BlockTypeOperators(new TypeOperators()));
    }

    private static LongArrayList addresses() {
        LongArrayList addresses = new LongArrayList();
        for (int i = 0; i < TEST_PAGE.getPositionCount(); ++i) {
            addresses.add(SyntheticAddress.encodeSyntheticAddress((int)0, (int)i));
        }
        return addresses;
    }
}

