/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.ExceededMemoryLimitException;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.operator.DriverContext;
import io.trino.operator.JoinOperatorType;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OperatorStats;
import io.trino.operator.TaskContext;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.JoinOperatorInfo;
import io.trino.operator.join.unspilled.JoinTestUtils;
import io.trino.operator.join.unspilled.PartitionedLookupSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import io.trino.util.FinalizerService;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestHashJoinOperator {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    private final NodePartitioningManager nodePartitioningManager = new NodePartitioningManager(new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)new InMemoryNodeManager(new InternalNode[0]), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(new FinalizerService()))), TYPE_OPERATORS, CatalogServiceProvider.fail());

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testInnerJoin() {
        this.testInnerJoin(false, false, false);
        this.testInnerJoin(false, false, true);
        this.testInnerJoin(false, true, false);
        this.testInnerJoin(false, true, true);
        this.testInnerJoin(true, false, false);
        this.testInnerJoin(true, false, true);
        this.testInnerJoin(true, true, false);
        this.testInnerJoin(true, true, true);
    }

    private void testInnerJoin(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty());
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        List<Page> probeInput = probePages.addSequencePage(1000, 0, 1000, 2000).build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probePages.getTypesWithoutHash(), buildPages.getTypesWithoutHash())).row(new Object[]{"20", 1020L, 2020L, "20", 30L, 40L}).row(new Object[]{"21", 1021L, 2021L, "21", 31L, 41L}).row(new Object[]{"22", 1022L, 2022L, "22", 32L, 42L}).row(new Object[]{"23", 1023L, 2023L, "23", 33L, 43L}).row(new Object[]{"24", 1024L, 2024L, "24", 34L, 44L}).row(new Object[]{"25", 1025L, 2025L, "25", 35L, 45L}).row(new Object[]{"26", 1026L, 2026L, "26", 36L, 46L}).row(new Object[]{"27", 1027L, 2027L, "27", 37L, 47L}).row(new Object[]{"28", 1028L, 2028L, "28", 38L, 48L}).row(new Object[]{"29", 1029L, 2029L, "29", 39L, 49L}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithRunLengthEncodedProbe() {
        this.testInnerJoinWithRunLengthEncodedProbe(false, false, false);
        this.testInnerJoinWithRunLengthEncodedProbe(false, false, true);
        this.testInnerJoinWithRunLengthEncodedProbe(false, true, false);
        this.testInnerJoinWithRunLengthEncodedProbe(false, true, true);
        this.testInnerJoinWithRunLengthEncodedProbe(true, false, false);
        this.testInnerJoinWithRunLengthEncodedProbe(true, false, true);
        this.testInnerJoinWithRunLengthEncodedProbe(true, true, false);
        this.testInnerJoinWithRunLengthEncodedProbe(true, true, true);
    }

    private void testInnerJoinWithRunLengthEncodedProbe(boolean withFilter, boolean probeHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)).row("20", 1L).row("21", 2L).row("21", 3L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, false, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePagesBuilder = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)).addBlocksPage(new Block[]{RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"20"), (int)2), BlockAssertions.createLongsBlock(42, 43)}).addBlocksPage(new Block[]{RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"-1"), (int)2), BlockAssertions.createLongsBlock(52, 53)}).addBlocksPage(new Block[]{RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"21"), (int)2), BlockAssertions.createLongsBlock(62, 63)});
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePagesBuilder, withFilter);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        List<Page> pages = OperatorAssertion.toPages(joinOperatorFactory, driverContext, probePagesBuilder.build(), true, true);
        if (probeHashEnabled) {
            pages = OperatorAssertion.dropChannel(pages, TestHashJoinOperator.getHashChannels(probePagesBuilder, buildPages));
        }
        Assertions.assertThat(pages).hasSize(2);
        if (withFilter) {
            Assertions.assertThat((Object)pages.get(0).getBlock(2)).isInstanceOf(VariableWidthBlock.class);
            Assertions.assertThat((Object)pages.get(0).getBlock(3)).isInstanceOf(LongArrayBlock.class);
        } else {
            Assertions.assertThat((Object)pages.get(0).getBlock(2)).isInstanceOf(RunLengthEncodedBlock.class);
            Assertions.assertThat((Object)pages.get(0).getBlock(3)).isInstanceOf(RunLengthEncodedBlock.class);
        }
        Assertions.assertThat((Object)pages.get(1).getBlock(2)).isInstanceOf(VariableWidthBlock.class);
        Assertions.assertThat((long)this.getJoinOperatorInfo(driverContext).getRleProbes()).isEqualTo(withFilter ? 0L : 2L);
        Assertions.assertThat((long)this.getJoinOperatorInfo(driverContext).getTotalProbes()).isEqualTo(3L);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probePagesBuilder.getTypesWithoutHash(), buildPages.getTypesWithoutHash())).row(new Object[]{"20", 42L, "20", 1L}).row(new Object[]{"20", 43L, "20", 1L}).row(new Object[]{"21", 62L, "21", 3L}).row(new Object[]{"21", 62L, "21", 2L}).row(new Object[]{"21", 63L, "21", 3L}).row(new Object[]{"21", 63L, "21", 2L}).build();
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), expected.getTypes(), pages);
        Assertions.assertThat((Iterable)actual).containsExactlyElementsOf((Iterable)expected);
    }

    private JoinOperatorInfo getJoinOperatorInfo(DriverContext driverContext) {
        return (JoinOperatorInfo)((OperatorStats)Iterables.getOnlyElement((Iterable)driverContext.getOperatorStats())).getInfo();
    }

    @Test
    public void testYield() {
        this.testYield(false);
        this.testYield(true);
    }

    private void testYield(boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        AtomicInteger filterFunctionCalls = new AtomicInteger();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> {
            filterFunctionCalls.incrementAndGet();
            driverContext.getYieldSignal().forceYieldForTesting();
            return true;
        });
        int entries = 40;
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(true, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addSequencePage(entries, 42);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, true, taskContext, buildPages, Optional.of(filterFunction), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT));
        List<Page> probeInput = probePages.addSequencePage(100, 0).build();
        OperatorFactory joinOperatorFactory = OperatorFactories.join((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactory, (boolean)true, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(driverContext);
        Assertions.assertThat((boolean)operator.needsInput()).isTrue();
        operator.addInput(probeInput.get(0));
        operator.finish();
        for (int i = 0; i < entries; ++i) {
            driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
            filterFunctionCalls.set(0);
            Assertions.assertThat((Object)operator.getOutput()).isNull();
            ((AbstractIntegerAssert)Assertions.assertThat((int)filterFunctionCalls.get()).describedAs("Expected join to stop processing (yield) after calling filter function once", new Object[0])).isEqualTo(1);
            driverContext.getYieldSignal().reset();
        }
        driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
        Page output = null;
        for (int i = 0; output == null && i < 5; ++i) {
            output = operator.getOutput();
        }
        Assertions.assertThat(output).isNotNull();
        driverContext.getYieldSignal().reset();
        Assertions.assertThat((int)output.getPositionCount()).isEqualTo(entries);
    }

    @Test
    public void testInnerJoinWithNullProbe() {
        this.testInnerJoinWithNullProbe(false, false, false, false);
        this.testInnerJoinWithNullProbe(false, false, false, true);
        this.testInnerJoinWithNullProbe(false, false, true, false);
        this.testInnerJoinWithNullProbe(false, false, true, true);
        this.testInnerJoinWithNullProbe(false, true, false, false);
        this.testInnerJoinWithNullProbe(false, true, false, true);
        this.testInnerJoinWithNullProbe(false, true, true, false);
        this.testInnerJoinWithNullProbe(false, true, true, true);
        this.testInnerJoinWithNullProbe(true, false, false, false);
        this.testInnerJoinWithNullProbe(true, false, false, true);
        this.testInnerJoinWithNullProbe(true, false, true, false);
        this.testInnerJoinWithNullProbe(true, false, true, true);
        this.testInnerJoinWithNullProbe(true, true, false, false);
        this.testInnerJoinWithNullProbe(true, true, false, true);
        this.testInnerJoinWithNullProbe(true, true, true, false);
        this.testInnerJoinWithNullProbe(true, true, true, true);
    }

    private void testInnerJoinWithNullProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row(1L).row(2L).row(3L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(new Object[]{null}).row(new Object[]{null}).row(1L).row(2L).build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildPages.getTypesWithoutHash())).row(new Object[]{1L, 1L}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithOutputSingleMatch() {
        this.testInnerJoinWithOutputSingleMatch(false, false, false, false);
        this.testInnerJoinWithOutputSingleMatch(false, false, false, true);
        this.testInnerJoinWithOutputSingleMatch(false, false, true, false);
        this.testInnerJoinWithOutputSingleMatch(false, false, true, true);
        this.testInnerJoinWithOutputSingleMatch(false, true, false, false);
        this.testInnerJoinWithOutputSingleMatch(false, true, false, true);
        this.testInnerJoinWithOutputSingleMatch(false, true, true, false);
        this.testInnerJoinWithOutputSingleMatch(false, true, true, true);
        this.testInnerJoinWithOutputSingleMatch(true, false, false, false);
        this.testInnerJoinWithOutputSingleMatch(true, false, false, true);
        this.testInnerJoinWithOutputSingleMatch(true, false, true, false);
        this.testInnerJoinWithOutputSingleMatch(true, false, true, true);
        this.testInnerJoinWithOutputSingleMatch(true, true, false, false);
        this.testInnerJoinWithOutputSingleMatch(true, true, false, true);
        this.testInnerJoinWithOutputSingleMatch(true, true, true, false);
        this.testInnerJoinWithOutputSingleMatch(true, true, true, true);
    }

    private void testInnerJoinWithOutputSingleMatch(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row(1L).row(1L).row(2L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(2L).row(3L).build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, true, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithNullBuild() {
        this.testInnerJoinWithNullBuild(false, false, false);
        this.testInnerJoinWithNullBuild(false, false, true);
        this.testInnerJoinWithNullBuild(false, true, false);
        this.testInnerJoinWithNullBuild(false, true, true);
        this.testInnerJoinWithNullBuild(true, false, false);
        this.testInnerJoinWithNullBuild(true, false, true);
        this.testInnerJoinWithNullBuild(true, true, false);
        this.testInnerJoinWithNullBuild(true, true, true);
    }

    private void testInnerJoinWithNullBuild(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row(1L).row(new Object[]{null}).row(new Object[]{null}).row(1L).row(2L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty());
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(2L).row(3L).build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{1L, 1L}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithNullOnBothSides() {
        this.testInnerJoinWithNullOnBothSides(false, false, false);
        this.testInnerJoinWithNullOnBothSides(false, false, true);
        this.testInnerJoinWithNullOnBothSides(false, true, false);
        this.testInnerJoinWithNullOnBothSides(false, true, true);
        this.testInnerJoinWithNullOnBothSides(true, false, false);
        this.testInnerJoinWithNullOnBothSides(true, false, true);
        this.testInnerJoinWithNullOnBothSides(true, true, false);
        this.testInnerJoinWithNullOnBothSides(true, true, true);
    }

    private void testInnerJoinWithNullOnBothSides(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row(1L).row(new Object[]{null}).row(new Object[]{null}).row(1L).row(2L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty());
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(2L).row(new Object[]{null}).row(3L).build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{1L, 1L}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testProbeOuterJoin() {
        this.testProbeOuterJoin(false, false, false);
        this.testProbeOuterJoin(false, false, true);
        this.testProbeOuterJoin(false, true, false);
        this.testProbeOuterJoin(false, true, true);
        this.testProbeOuterJoin(true, false, false);
        this.testProbeOuterJoin(true, false, true);
        this.testProbeOuterJoin(true, true, false);
        this.testProbeOuterJoin(true, true, true);
    }

    private void testProbeOuterJoin(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty());
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.addSequencePage(15, 20, 1020, 2020).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"20", 1020L, 2020L, "20", 30L, 40L}).row(new Object[]{"21", 1021L, 2021L, "21", 31L, 41L}).row(new Object[]{"22", 1022L, 2022L, "22", 32L, 42L}).row(new Object[]{"23", 1023L, 2023L, "23", 33L, 43L}).row(new Object[]{"24", 1024L, 2024L, "24", 34L, 44L}).row(new Object[]{"25", 1025L, 2025L, "25", 35L, 45L}).row(new Object[]{"26", 1026L, 2026L, "26", 36L, 46L}).row(new Object[]{"27", 1027L, 2027L, "27", 37L, 47L}).row(new Object[]{"28", 1028L, 2028L, "28", 38L, 48L}).row(new Object[]{"29", 1029L, 2029L, "29", 39L, 49L}).row(new Object[]{"30", 1030L, 2030L, null, null, null}).row(new Object[]{"31", 1031L, 2031L, null, null, null}).row(new Object[]{"32", 1032L, 2032L, null, null, null}).row(new Object[]{"33", 1033L, 2033L, null, null, null}).row(new Object[]{"34", 1034L, 2034L, null, null, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testProbeOuterJoinWithFilterFunction() {
        this.testProbeOuterJoinWithFilterFunction(false, false, false);
        this.testProbeOuterJoinWithFilterFunction(false, false, true);
        this.testProbeOuterJoinWithFilterFunction(false, true, false);
        this.testProbeOuterJoinWithFilterFunction(false, true, true);
        this.testProbeOuterJoinWithFilterFunction(true, false, false);
        this.testProbeOuterJoinWithFilterFunction(true, false, true);
        this.testProbeOuterJoinWithFilterFunction(true, true, false);
        this.testProbeOuterJoinWithFilterFunction(true, true, true);
    }

    private void testProbeOuterJoinWithFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(1), rightPosition) >= 1025L);
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction));
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.addSequencePage(15, 20, 1020, 2020).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"20", 1020L, 2020L, null, null, null}).row(new Object[]{"21", 1021L, 2021L, null, null, null}).row(new Object[]{"22", 1022L, 2022L, null, null, null}).row(new Object[]{"23", 1023L, 2023L, null, null, null}).row(new Object[]{"24", 1024L, 2024L, null, null, null}).row(new Object[]{"25", 1025L, 2025L, "25", 35L, 45L}).row(new Object[]{"26", 1026L, 2026L, "26", 36L, 46L}).row(new Object[]{"27", 1027L, 2027L, "27", 37L, 47L}).row(new Object[]{"28", 1028L, 2028L, "28", 38L, 48L}).row(new Object[]{"29", 1029L, 2029L, "29", 39L, 49L}).row(new Object[]{"30", 1030L, 2030L, null, null, null}).row(new Object[]{"31", 1031L, 2031L, null, null, null}).row(new Object[]{"32", 1032L, 2032L, null, null, null}).row(new Object[]{"33", 1033L, 2033L, null, null, null}).row(new Object[]{"34", 1034L, 2034L, null, null, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullProbe() {
        this.testOuterJoinWithNullProbe(false, false, false, false);
        this.testOuterJoinWithNullProbe(false, false, false, true);
        this.testOuterJoinWithNullProbe(false, false, true, false);
        this.testOuterJoinWithNullProbe(false, false, true, true);
        this.testOuterJoinWithNullProbe(false, true, false, false);
        this.testOuterJoinWithNullProbe(false, true, false, true);
        this.testOuterJoinWithNullProbe(false, true, true, false);
        this.testOuterJoinWithNullProbe(false, true, true, true);
        this.testOuterJoinWithNullProbe(true, false, false, false);
        this.testOuterJoinWithNullProbe(true, false, false, true);
        this.testOuterJoinWithNullProbe(true, false, true, false);
        this.testOuterJoinWithNullProbe(true, false, true, true);
        this.testOuterJoinWithNullProbe(true, true, false, false);
        this.testOuterJoinWithNullProbe(true, true, false, true);
        this.testOuterJoinWithNullProbe(true, true, true, false);
        this.testOuterJoinWithNullProbe(true, true, true, true);
    }

    private void testOuterJoinWithNullProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row(1L).row(2L).row(3L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(new Object[]{null}).row(new Object[]{null}).row(1L).row(2L).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{1L, 1L}).row(new Object[]{null, null}).row(new Object[]{null, null}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullProbeAndFilterFunction() {
        this.testOuterJoinWithNullProbeAndFilterFunction(false, false, false, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, false, false, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, false, true, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, false, true, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, true, false, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, true, false, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, true, true, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, true, true, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, false, false, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, false, false, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, false, true, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, false, true, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, true, false, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, true, false, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, true, true, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, true, true, true);
    }

    private void testOuterJoinWithNullProbeAndFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(0), rightPosition) == 1L);
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row(1L).row(2L).row(3L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(new Object[]{null}).row(new Object[]{null}).row(1L).row(2L).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{1L, 1L}).row(new Object[]{null, null}).row(new Object[]{null, null}).row(new Object[]{1L, 1L}).row(new Object[]{2L, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullBuild() {
        this.testOuterJoinWithNullBuild(false, false, false, false);
        this.testOuterJoinWithNullBuild(false, false, false, true);
        this.testOuterJoinWithNullBuild(false, false, true, false);
        this.testOuterJoinWithNullBuild(false, false, true, true);
        this.testOuterJoinWithNullBuild(false, true, false, false);
        this.testOuterJoinWithNullBuild(false, true, false, true);
        this.testOuterJoinWithNullBuild(false, true, true, false);
        this.testOuterJoinWithNullBuild(false, true, true, true);
        this.testOuterJoinWithNullBuild(true, false, false, false);
        this.testOuterJoinWithNullBuild(true, false, false, true);
        this.testOuterJoinWithNullBuild(true, false, true, false);
        this.testOuterJoinWithNullBuild(true, false, true, true);
        this.testOuterJoinWithNullBuild(true, true, false, false);
        this.testOuterJoinWithNullBuild(true, true, false, true);
        this.testOuterJoinWithNullBuild(true, true, true, false);
        this.testOuterJoinWithNullBuild(true, true, true, true);
    }

    private void testOuterJoinWithNullBuild(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT)).row(1L).row(new Object[]{null}).row(new Object[]{null}).row(1L).row(2L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(2L).row(3L).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{1L, 1L}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).row(new Object[]{3L, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullBuildAndFilterFunction() {
        this.testOuterJoinWithNullBuildAndFilterFunction(false, false, false, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, false, false, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, false, true, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, false, true, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, true, false, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, true, false, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, true, true, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, true, true, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, false, false, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, false, false, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, false, true, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, false, true, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, true, false, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, true, false, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, true, true, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, true, true, true);
    }

    private void testOuterJoinWithNullBuildAndFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> ImmutableSet.of((Object)1L, (Object)3L).contains((Object)BigintType.BIGINT.getLong(rightPage.getBlock(0), rightPosition)));
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT)).row(1L).row(new Object[]{null}).row(new Object[]{null}).row(1L).row(2L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(2L).row(3L).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{1L, 1L}).row(new Object[]{1L, 1L}).row(new Object[]{2L, null}).row(new Object[]{3L, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullOnBothSides() {
        this.testOuterJoinWithNullOnBothSides(false, false, false, false);
        this.testOuterJoinWithNullOnBothSides(false, false, false, true);
        this.testOuterJoinWithNullOnBothSides(false, false, true, false);
        this.testOuterJoinWithNullOnBothSides(false, false, true, true);
        this.testOuterJoinWithNullOnBothSides(false, true, false, false);
        this.testOuterJoinWithNullOnBothSides(false, true, false, true);
        this.testOuterJoinWithNullOnBothSides(false, true, true, false);
        this.testOuterJoinWithNullOnBothSides(false, true, true, true);
        this.testOuterJoinWithNullOnBothSides(true, false, false, false);
        this.testOuterJoinWithNullOnBothSides(true, false, false, true);
        this.testOuterJoinWithNullOnBothSides(true, false, true, false);
        this.testOuterJoinWithNullOnBothSides(true, false, true, true);
        this.testOuterJoinWithNullOnBothSides(true, true, false, false);
        this.testOuterJoinWithNullOnBothSides(true, true, false, true);
        this.testOuterJoinWithNullOnBothSides(true, true, true, false);
        this.testOuterJoinWithNullOnBothSides(true, true, true, true);
    }

    private void testOuterJoinWithNullOnBothSides(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT)).row(1L).row(new Object[]{null}).row(new Object[]{null}).row(1L).row(2L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(2L).row(new Object[]{null}).row(3L).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildPages.getTypesWithoutHash())).row(new Object[]{1L, 1L}).row(new Object[]{1L, 1L}).row(new Object[]{2L, 2L}).row(new Object[]{null, null}).row(new Object[]{3L, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullOnBothSidesAndFilterFunction() {
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, false, false, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, false, false, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, false, true, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, false, true, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, true, false, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, true, false, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, true, true, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, true, true, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, false, false, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, false, false, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, false, true, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, false, true, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, true, false, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, true, false, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, true, true, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, true, true, true);
    }

    private void testOuterJoinWithNullOnBothSidesAndFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> ImmutableSet.of((Object)1L, (Object)3L).contains((Object)BigintType.BIGINT.getLong(rightPage.getBlock(0), rightPosition)));
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT)).row(1L).row(new Object[]{null}).row(new Object[]{null}).row(1L).row(2L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(2L).row(new Object[]{null}).row(3L).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildPages.getTypesWithoutHash())).row(new Object[]{1L, 1L}).row(new Object[]{1L, 1L}).row(new Object[]{2L, null}).row(new Object[]{null, null}).row(new Object[]{3L, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testMemoryLimit() {
        this.testMemoryLimit(false, false);
        this.testMemoryLimit(false, true);
        this.testMemoryLimit(true, false);
        this.testMemoryLimit(true, true);
    }

    private void testMemoryLimit(boolean parallelBuild, boolean buildHashEnabled) {
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.ofBytes((long)100L));
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty());
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JoinTestUtils.buildLookupSource(this.executor, buildSideSetup)).isInstanceOf(ExceededMemoryLimitException.class)).hasMessageMatching("Query exceeded per-node memory limit of.*");
    }

    @Test
    public void testInnerJoinWithEmptyLookupSource() {
        this.testInnerJoinWithEmptyLookupSource(false, false, false, false);
        this.testInnerJoinWithEmptyLookupSource(false, false, false, true);
        this.testInnerJoinWithEmptyLookupSource(false, false, true, false);
        this.testInnerJoinWithEmptyLookupSource(false, false, true, true);
        this.testInnerJoinWithEmptyLookupSource(false, true, false, false);
        this.testInnerJoinWithEmptyLookupSource(false, true, false, true);
        this.testInnerJoinWithEmptyLookupSource(false, true, true, false);
        this.testInnerJoinWithEmptyLookupSource(false, true, true, true);
        this.testInnerJoinWithEmptyLookupSource(true, false, false, false);
        this.testInnerJoinWithEmptyLookupSource(true, false, false, true);
        this.testInnerJoinWithEmptyLookupSource(true, false, true, false);
        this.testInnerJoinWithEmptyLookupSource(true, false, true, true);
        this.testInnerJoinWithEmptyLookupSource(true, true, false, false);
        this.testInnerJoinWithEmptyLookupSource(true, true, false, true);
        this.testInnerJoinWithEmptyLookupSource(true, true, true, false);
        this.testInnerJoinWithEmptyLookupSource(true, true, true, true);
    }

    private void testInnerJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        OperatorFactory joinOperatorFactory = OperatorFactories.join((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, (boolean)false, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(taskContext.addPipelineContext(0, true, true, false).addDriverContext());
        List<Page> pages = probePages.row(1L).build();
        operator.addInput(pages.get(0));
        Page outputPage = operator.getOutput();
        Assertions.assertThat((Object)outputPage).isNull();
    }

    @Test
    public void testLookupOuterJoinWithEmptyLookupSource() {
        this.testLookupOuterJoinWithEmptyLookupSource(false, false, false, false);
        this.testLookupOuterJoinWithEmptyLookupSource(false, false, false, true);
        this.testLookupOuterJoinWithEmptyLookupSource(false, false, true, false);
        this.testLookupOuterJoinWithEmptyLookupSource(false, false, true, true);
        this.testLookupOuterJoinWithEmptyLookupSource(false, true, false, false);
        this.testLookupOuterJoinWithEmptyLookupSource(false, true, false, true);
        this.testLookupOuterJoinWithEmptyLookupSource(false, true, true, false);
        this.testLookupOuterJoinWithEmptyLookupSource(false, true, true, true);
        this.testLookupOuterJoinWithEmptyLookupSource(true, false, false, false);
        this.testLookupOuterJoinWithEmptyLookupSource(true, false, false, true);
        this.testLookupOuterJoinWithEmptyLookupSource(true, false, true, false);
        this.testLookupOuterJoinWithEmptyLookupSource(true, false, true, true);
        this.testLookupOuterJoinWithEmptyLookupSource(true, true, false, false);
        this.testLookupOuterJoinWithEmptyLookupSource(true, true, false, true);
        this.testLookupOuterJoinWithEmptyLookupSource(true, true, true, false);
        this.testLookupOuterJoinWithEmptyLookupSource(true, true, true, true);
    }

    private void testLookupOuterJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        OperatorFactory joinOperatorFactory = OperatorFactories.join((JoinOperatorType)JoinOperatorType.lookupOuterJoin((boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, (boolean)false, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(taskContext.addPipelineContext(0, true, true, false).addDriverContext());
        List<Page> pages = probePages.row(1L).build();
        operator.addInput(pages.get(0));
        Page outputPage = operator.getOutput();
        Assertions.assertThat((Object)outputPage).isNull();
    }

    @Test
    public void testProbeOuterJoinWithEmptyLookupSource() {
        this.testProbeOuterJoinWithEmptyLookupSource(false, false, false, false);
        this.testProbeOuterJoinWithEmptyLookupSource(false, false, false, true);
        this.testProbeOuterJoinWithEmptyLookupSource(false, false, true, false);
        this.testProbeOuterJoinWithEmptyLookupSource(false, false, true, true);
        this.testProbeOuterJoinWithEmptyLookupSource(false, true, false, false);
        this.testProbeOuterJoinWithEmptyLookupSource(false, true, false, true);
        this.testProbeOuterJoinWithEmptyLookupSource(false, true, true, false);
        this.testProbeOuterJoinWithEmptyLookupSource(false, true, true, true);
        this.testProbeOuterJoinWithEmptyLookupSource(true, false, false, false);
        this.testProbeOuterJoinWithEmptyLookupSource(true, false, false, true);
        this.testProbeOuterJoinWithEmptyLookupSource(true, false, true, false);
        this.testProbeOuterJoinWithEmptyLookupSource(true, false, true, true);
        this.testProbeOuterJoinWithEmptyLookupSource(true, true, false, false);
        this.testProbeOuterJoinWithEmptyLookupSource(true, true, false, true);
        this.testProbeOuterJoinWithEmptyLookupSource(true, true, true, false);
        this.testProbeOuterJoinWithEmptyLookupSource(true, true, true, true);
    }

    private void testProbeOuterJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(2L).row(new Object[]{null}).row(3L).build();
        OperatorFactory joinOperatorFactory = OperatorFactories.join((JoinOperatorType)JoinOperatorType.probeOuterJoin((boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, (boolean)false, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{1L, null}).row(new Object[]{2L, null}).row(new Object[]{null, null}).row(new Object[]{3L, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testFullOuterJoinWithEmptyLookupSource() {
        this.testFullOuterJoinWithEmptyLookupSource(false, false, false, false);
        this.testFullOuterJoinWithEmptyLookupSource(false, false, false, true);
        this.testFullOuterJoinWithEmptyLookupSource(false, false, true, false);
        this.testFullOuterJoinWithEmptyLookupSource(false, false, true, true);
        this.testFullOuterJoinWithEmptyLookupSource(false, true, false, false);
        this.testFullOuterJoinWithEmptyLookupSource(false, true, false, true);
        this.testFullOuterJoinWithEmptyLookupSource(false, true, true, false);
        this.testFullOuterJoinWithEmptyLookupSource(false, true, true, true);
        this.testFullOuterJoinWithEmptyLookupSource(true, false, false, false);
        this.testFullOuterJoinWithEmptyLookupSource(true, false, false, true);
        this.testFullOuterJoinWithEmptyLookupSource(true, false, true, false);
        this.testFullOuterJoinWithEmptyLookupSource(true, false, true, true);
        this.testFullOuterJoinWithEmptyLookupSource(true, true, false, false);
        this.testFullOuterJoinWithEmptyLookupSource(true, true, false, true);
        this.testFullOuterJoinWithEmptyLookupSource(true, true, true, false);
        this.testFullOuterJoinWithEmptyLookupSource(true, true, true, true);
    }

    private void testFullOuterJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row(1L).row(2L).row(new Object[]{null}).row(3L).build();
        OperatorFactory joinOperatorFactory = OperatorFactories.join((JoinOperatorType)JoinOperatorType.fullOuterJoin(), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, (boolean)false, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{1L, null}).row(new Object[]{2L, null}).row(new Object[]{null, null}).row(new Object[]{3L, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe() {
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, false, false, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, false, false, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, false, true, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, false, true, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, true, false, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, true, false, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, true, true, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, true, true, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, false, false, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, false, false, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, false, true, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, false, true, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, true, false, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, true, false, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, true, true, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, true, true, true);
    }

    private void testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean singleBigintLookupSource) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row(1L).row(2L).row(new Object[]{null}).row(3L);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), singleBigintLookupSource);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.build();
        OperatorFactory joinOperatorFactory = OperatorFactories.join((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, (boolean)false, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithBlockingLookupSourceAndEmptyProbe() throws Exception {
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(false, false, false);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(false, false, true);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(false, true, false);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(false, true, true);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(true, false, false);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(true, false, true);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(true, true, false);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(true, true, true);
    }

    private void testInnerJoinWithBlockingLookupSourceAndEmptyProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) throws Exception {
        TaskContext taskContext = this.createTaskContext();
        OperatorFactory joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, true);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        try (Operator joinOperator = joinOperatorFactory.createOperator(driverContext);){
            joinOperatorFactory.noMoreOperators();
            Assertions.assertThat((boolean)joinOperator.needsInput()).isFalse();
            joinOperator.finish();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isFalse();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isFalse();
        }
        taskContext = this.createTaskContext();
        joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, false);
        driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        joinOperator = joinOperatorFactory.createOperator(driverContext);
        try {
            joinOperatorFactory.noMoreOperators();
            Assertions.assertThat((boolean)joinOperator.needsInput()).isTrue();
            joinOperator.finish();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isTrue();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isTrue();
        }
        finally {
            if (joinOperator != null) {
                joinOperator.close();
            }
        }
    }

    @Test
    public void testInnerJoinWithBlockingLookupSource() throws Exception {
        this.testInnerJoinWithBlockingLookupSource(false, false, false);
        this.testInnerJoinWithBlockingLookupSource(false, false, true);
        this.testInnerJoinWithBlockingLookupSource(false, true, false);
        this.testInnerJoinWithBlockingLookupSource(false, true, true);
        this.testInnerJoinWithBlockingLookupSource(true, false, false);
        this.testInnerJoinWithBlockingLookupSource(true, false, true);
        this.testInnerJoinWithBlockingLookupSource(true, true, false);
        this.testInnerJoinWithBlockingLookupSource(true, true, true);
    }

    private void testInnerJoinWithBlockingLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) throws Exception {
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
        Page probePage = (Page)Iterables.getOnlyElement(probePages.addSequencePage(1, 0).build());
        TaskContext taskContext = this.createTaskContext();
        OperatorFactory joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, true);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        try (Operator joinOperator = joinOperatorFactory.createOperator(driverContext);){
            joinOperatorFactory.noMoreOperators();
            Assertions.assertThat((boolean)joinOperator.needsInput()).isFalse();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isFalse();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isFalse();
        }
        taskContext = this.createTaskContext();
        joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, false);
        driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        joinOperator = joinOperatorFactory.createOperator(driverContext);
        try {
            joinOperatorFactory.noMoreOperators();
            Assertions.assertThat((boolean)joinOperator.needsInput()).isTrue();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isTrue();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isFalse();
            joinOperator.addInput(probePage);
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isFalse();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isFalse();
        }
        finally {
            if (joinOperator != null) {
                joinOperator.close();
            }
        }
    }

    private OperatorFactory createJoinOperatorFactoryWithBlockingLookupSource(TaskContext taskContext, boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean waitForBuild) {
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty());
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        OperatorFactory joinOperatorFactory = OperatorFactories.join((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)waitForBuild), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, (boolean)false, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        return joinOperatorFactory;
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }

    private static List<Integer> getHashChannels(RowPagesBuilder probe, RowPagesBuilder build) {
        ImmutableList.Builder hashChannels = ImmutableList.builder();
        if (probe.getHashChannel().isPresent()) {
            hashChannels.add((Object)probe.getHashChannel().get());
        }
        if (build.getHashChannel().isPresent()) {
            hashChannels.add((Object)(probe.getTypes().size() + build.getHashChannel().get()));
        }
        return hashChannels.build();
    }

    private OperatorFactory probeOuterJoinOperatorFactory(JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager, RowPagesBuilder probePages, boolean hasFilter) {
        return OperatorFactories.join((JoinOperatorType)JoinOperatorType.probeOuterJoin((boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, (boolean)hasFilter, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (TypeOperators)TYPE_OPERATORS);
    }

    private static <T> List<T> concat(List<T> initialElements, List<T> moreElements) {
        return ImmutableList.copyOf((Iterable)Iterables.concat(initialElements, moreElements));
    }
}

