/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.type.UnknownType;
import io.trino.util.StructuralTestUtil;
import java.util.HashMap;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestMapFilterFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testEmpty() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> true)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> false)").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> CAST (NULL AS BOOLEAN))").binding("a", "map(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> true)").binding("a", "CAST(map(ARRAY[], ARRAY[]) AS MAP(BIGINT, VARCHAR))")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of());
    }

    @Test
    public void testNull() {
        HashMap<Integer, Object> oneToNullMap = new HashMap<Integer, Object>();
        oneToNullMap.put(1, null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> v IS NULL)").binding("a", "map(ARRAY[1], ARRAY[NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN)).isEqualTo(oneToNullMap);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> v IS NOT NULL)").binding("a", "map(ARRAY[1], ARRAY[NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> v IS NULL)").binding("a", "map(ARRAY[1], ARRAY[CAST (NULL AS INTEGER)])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(oneToNullMap);
        HashMap<Integer, Object> sequenceToNullMap = new HashMap<Integer, Object>();
        sequenceToNullMap.put(1, null);
        sequenceToNullMap.put(2, null);
        sequenceToNullMap.put(3, null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> v IS NULL)").binding("a", "map(ARRAY[1, 2, 3], ARRAY[NULL, NULL, NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN)).isEqualTo(sequenceToNullMap);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> v IS NOT NULL)").binding("a", "map(ARRAY[1, 2, 3], ARRAY[NULL, NULL, NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (x, y) -> x <= 6 OR y = 5)").binding("a", "map(ARRAY[5, 6, 7, 8], ARRAY[5, 6, 6, 5])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)5, (Object)5, (Object)6, (Object)6, (Object)8, (Object)5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (x, y) -> x <= 6 OR y = 5)").binding("a", "map(ARRAY[5 + RANDOM(1), 6, 7, 8], ARRAY[5, 6, 6, 5])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)5, (Object)5, (Object)6, (Object)6, (Object)8, (Object)5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> v IS NOT NULL)").binding("a", "map(ARRAY['a', 'b', 'c', 'd'], ARRAY[1, 2, NULL, 4])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"d", (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> v)").binding("a", "map(ARRAY['a', 'b', 'c'], ARRAY[TRUE, FALSE, NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)"a", (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> year(k) = 1111)").binding("a", "map(ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'], ARRAY[1, 2])")))).matches("map_from_entries(array[(TIMESTAMP '1111-05-10 12:34:56.123456789', 2)])");
    }

    @Test
    public void testTypeCombinations() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25 OR v = 27)").binding("a", "map(ARRAY[25, 26, 27], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)25, (Object)25, (Object)27, (Object)27));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25 OR v = 27.5E0)").binding("a", "map(ARRAY[25, 26, 27], ARRAY[25.5E0, 26.5E0, 27.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)25, (Object)25.5, (Object)27, (Object)27.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25 OR v)").binding("a", "map(ARRAY[25, 26, 27], ARRAY[false, null, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)25, (Object)false, (Object)27, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25 OR v = 'xyz')").binding("a", "map(ARRAY[25, 26, 27], ARRAY['abc', 'def', 'xyz'])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableMap.of((Object)25, (Object)"abc", (Object)27, (Object)"xyz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25 OR cardinality(v) = 3)").binding("a", "map(ARRAY[25, 26, 27], ARRAY[ARRAY['a', 'b'], ARRAY['a', 'c'], ARRAY['a', 'b', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)25, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)27, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25.5E0 OR v = 27)").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)25.5, (Object)25, (Object)27.5, (Object)27));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25.5E0 OR v = 27.5E0)").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY[25.5E0, 26.5E0, 27.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)25.5, (Object)25.5, (Object)27.5, (Object)27.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25.5E0 OR v)").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY[false, null, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)25.5, (Object)false, (Object)27.5, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25.5E0 OR v = 'xyz')").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY['abc', 'def', 'xyz'])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableMap.of((Object)25.5, (Object)"abc", (Object)27.5, (Object)"xyz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 25.5E0 OR cardinality(v) = 3)").binding("a", "map(ARRAY[25.5E0, 26.5E0, 27.5E0], ARRAY[ARRAY['a', 'b'], ARRAY['a', 'c'], ARRAY['a', 'b', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)25.5, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)27.5, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k AND v = 25)").binding("a", "map(ARRAY[true, false], ARRAY[25, 26])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)true, (Object)25));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k OR v > 100)").binding("a", "map(ARRAY[false, true], ARRAY[25.5E0, 26.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)true, (Object)26.5));
        HashMap<Boolean, Object> falseToNullMap = new HashMap<Boolean, Object>();
        falseToNullMap.put(false, null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> NOT k OR v)").binding("a", "map(ARRAY[true, false], ARRAY[false, null])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(falseToNullMap);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> NOT k AND v = 'abc')").binding("a", "map(ARRAY[false, true], ARRAY['abc', 'def'])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableMap.of((Object)false, (Object)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k OR cardinality(v) = 3)").binding("a", "map(ARRAY[true, false], ARRAY[ARRAY['a', 'b'], ARRAY['a', 'b', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)true, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)false, (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 's0' OR v = 27)").binding("a", "map(ARRAY['s0', 's1', 's2'], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)"s0", (Object)25, (Object)"s2", (Object)27));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 's0' OR v = 27.5E0)").binding("a", "map(ARRAY['s0', 's1', 's2'], ARRAY[25.5E0, 26.5E0, 27.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)"s0", (Object)25.5, (Object)"s2", (Object)27.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 's0' OR v)").binding("a", "map(ARRAY['s0', 's1', 's2'], ARRAY[false, null, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)"s0", (Object)false, (Object)"s2", (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 's0' OR v = 'xyz')").binding("a", "map(ARRAY['s0', 's1', 's2'], ARRAY['abc', 'def', 'xyz'])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableMap.of((Object)"s0", (Object)"abc", (Object)"s2", (Object)"xyz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = 's0' OR cardinality(v) = 3)").binding("a", "map(ARRAY['s0', 's1', 's2'], ARRAY[ARRAY['a', 'b'], ARRAY['a', 'c'], ARRAY['a', 'b', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)"s0", (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)"s2", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = ARRAY[1, 2] OR v = 27)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4], ARRAY[]], ARRAY[25, 26, 27])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)25, (Object)ImmutableList.of(), (Object)27));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = ARRAY[1, 2] OR v = 27.5E0)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4], ARRAY[]], ARRAY[25.5E0, 26.5E0, 27.5E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)25.5, (Object)ImmutableList.of(), (Object)27.5));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = ARRAY[1, 2] OR v)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4], ARRAY[]], ARRAY[false, null, true])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)false, (Object)ImmutableList.of(), (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> k = ARRAY[1, 2] OR v = 'xyz')").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4], ARRAY[]], ARRAY['abc', 'def', 'xyz'])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)VarcharType.createVarcharType((int)3))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)"abc", (Object)ImmutableList.of(), (Object)"xyz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_filter(a, (k, v) -> cardinality(k) = 0 OR cardinality(v) = 3)").binding("a", "map(ARRAY[ARRAY[1, 2], ARRAY[3, 4], ARRAY[]], ARRAY[ARRAY['a', 'b'], ARRAY['a', 'b', 'c'], ARRAY['a', 'c']])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"a", (Object)"c")));
    }
}

