/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.RowBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;

public final class TestingUnnesterUtil {
    private TestingUnnesterUtil() {
    }

    static UnnestedLengths calculateMaxCardinalities(Page page, List<Type> replicatedTypes, List<Type> unnestTypes, boolean outer) {
        int positionCount = page.getPositionCount();
        int[] maxCardinalities = new int[positionCount];
        int replicatedChannelCount = replicatedTypes.size();
        int unnestChannelCount = unnestTypes.size();
        for (int i = 0; i < unnestChannelCount; ++i) {
            int j;
            Type type = unnestTypes.get(i);
            Block block = page.getBlock(replicatedChannelCount + i);
            Assertions.assertThat((type instanceof ArrayType || type instanceof MapType ? 1 : 0) != 0).isTrue();
            if (type instanceof ArrayType) {
                ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
                for (j = 0; j < positionCount; ++j) {
                    maxCardinalities[j] = Math.max(maxCardinalities[j], columnarArray.getLength(j));
                }
                continue;
            }
            ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
            for (j = 0; j < positionCount; ++j) {
                maxCardinalities[j] = Math.max(maxCardinalities[j], columnarMap.getEntryCount(j));
            }
        }
        if (outer) {
            boolean[] nullAppendForOuter = new boolean[positionCount];
            for (int j = 0; j < positionCount; ++j) {
                if (maxCardinalities[j] != 0) continue;
                maxCardinalities[j] = 1;
                nullAppendForOuter[j] = true;
            }
            return new UnnestedLengths(maxCardinalities, Optional.of(nullAppendForOuter));
        }
        return new UnnestedLengths(maxCardinalities, Optional.empty());
    }

    static Page buildExpectedPage(Page page, List<Type> replicatedTypes, List<Type> unnestTypes, List<Type> outputTypes, UnnestedLengths unnestedLengths, boolean withOrdinality) {
        int i;
        int totalEntries = IntStream.of(unnestedLengths.getMaxCardinalities()).sum();
        int[] maxCardinalities = unnestedLengths.getMaxCardinalities();
        int channelCount = page.getChannelCount();
        Assertions.assertThat((channelCount > 1 ? 1 : 0) != 0).isTrue();
        Block[] outputBlocks = new Block[outputTypes.size()];
        int outputChannel = 0;
        for (i = 0; i < replicatedTypes.size(); ++i) {
            outputBlocks[outputChannel++] = TestingUnnesterUtil.buildExpectedReplicatedBlock(page.getBlock(i), replicatedTypes.get(i), maxCardinalities, totalEntries);
        }
        for (i = 0; i < unnestTypes.size(); ++i) {
            Type type = unnestTypes.get(i);
            Block inputBlock = page.getBlock(replicatedTypes.size() + i);
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                Type elementType = arrayType.getElementType();
                if (elementType instanceof RowType) {
                    Block[] blocks;
                    List rowTypes = elementType.getTypeParameters();
                    for (Block block : blocks = TestingUnnesterUtil.buildExpectedUnnestedArrayOfRowBlock(inputBlock, rowTypes, maxCardinalities, totalEntries)) {
                        outputBlocks[outputChannel++] = block;
                    }
                    continue;
                }
                outputBlocks[outputChannel++] = TestingUnnesterUtil.buildExpectedUnnestedArrayBlock(inputBlock, ((ArrayType)unnestTypes.get(i)).getElementType(), maxCardinalities, totalEntries);
                continue;
            }
            if (type instanceof MapType) {
                Block[] blocks;
                MapType mapType = (MapType)type;
                for (Block block : blocks = TestingUnnesterUtil.buildExpectedUnnestedMapBlocks(inputBlock, mapType.getKeyType(), mapType.getValueType(), maxCardinalities, totalEntries)) {
                    outputBlocks[outputChannel++] = block;
                }
                continue;
            }
            throw new RuntimeException("expected an ArrayType or MapType, but found " + String.valueOf(type));
        }
        if (withOrdinality) {
            outputBlocks[outputChannel] = TestingUnnesterUtil.buildExpectedOrdinalityBlock(unnestedLengths, totalEntries);
        }
        return new Page(outputBlocks);
    }

    static List<Type> buildOutputTypes(List<Type> replicatedTypes, List<Type> unnestTypes, boolean withOrdinality) {
        ArrayList<Type> outputTypes = new ArrayList<Type>(replicatedTypes);
        for (Type unnestType : unnestTypes) {
            if (unnestType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)unnestType;
                Type elementType = arrayType.getElementType();
                if (elementType instanceof RowType) {
                    List rowTypes = elementType.getTypeParameters();
                    outputTypes.addAll(rowTypes);
                    continue;
                }
                outputTypes.add(elementType);
                continue;
            }
            if (!(unnestType instanceof MapType)) continue;
            MapType mapType = (MapType)unnestType;
            outputTypes.add(mapType.getKeyType());
            outputTypes.add(mapType.getValueType());
        }
        if (withOrdinality) {
            outputTypes.add((Type)BigintType.BIGINT);
        }
        return outputTypes;
    }

    static Page mergePages(List<Type> types, List<Page> pages) {
        PageBuilder pageBuilder = new PageBuilder(types);
        int totalPositionCount = 0;
        for (Page page : pages) {
            Verify.verify((page.getChannelCount() == types.size() ? 1 : 0) != 0, (String)String.format("Number of channels in page %d is not equal to number of types %d", page.getChannelCount(), types.size()), (Object[])new Object[0]);
            for (int i = 0; i < types.size(); ++i) {
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                Block block = page.getBlock(i);
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    types.get(i).appendTo(block, position, blockBuilder);
                }
            }
            totalPositionCount += page.getPositionCount();
        }
        pageBuilder.declarePositions(totalPositionCount);
        return pageBuilder.build();
    }

    private static Block buildExpectedReplicatedBlock(Block block, Type type, int[] maxCardinalities, int totalEntries) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, totalEntries);
        int positionCount = block.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            int cardinality = maxCardinalities[i];
            for (int j = 0; j < cardinality; ++j) {
                type.appendTo(block, i, blockBuilder);
            }
        }
        return blockBuilder.build();
    }

    private static Block buildExpectedUnnestedArrayBlock(Block block, Type type, int[] maxCardinalities, int totalEntries) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
        Block elementBlock = columnarArray.getElementsBlock();
        BlockBuilder blockBuilder = type.createBlockBuilder(null, totalEntries);
        int positionCount = block.getPositionCount();
        int elementBlockPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int cardinality = columnarArray.getLength(i);
            for (int j = 0; j < cardinality; ++j) {
                type.appendTo(elementBlock, elementBlockPosition++, blockBuilder);
            }
            int maxCardinality = maxCardinalities[i];
            for (int j = cardinality; j < maxCardinality; ++j) {
                blockBuilder.appendNull();
            }
        }
        return blockBuilder.build();
    }

    private static Block[] buildExpectedUnnestedMapBlocks(Block block, Type keyType, Type valueType, int[] maxCardinalities, int totalEntries) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        Block keyBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        BlockBuilder keyBlockBuilder = keyType.createBlockBuilder(null, totalEntries);
        BlockBuilder valueBlockBuilder = valueType.createBlockBuilder(null, totalEntries);
        int positionCount = block.getPositionCount();
        int blockPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int cardinality = columnarMap.getEntryCount(i);
            for (int j = 0; j < cardinality; ++j) {
                keyType.appendTo(keyBlock, blockPosition, keyBlockBuilder);
                valueType.appendTo(valuesBlock, blockPosition, valueBlockBuilder);
                ++blockPosition;
            }
            int maxCardinality = maxCardinalities[i];
            for (int j = cardinality; j < maxCardinality; ++j) {
                keyBlockBuilder.appendNull();
                valueBlockBuilder.appendNull();
            }
        }
        Block[] blocks = new Block[]{keyBlockBuilder.build(), valueBlockBuilder.build()};
        return blocks;
    }

    private static Block[] buildExpectedUnnestedArrayOfRowBlock(Block block, List<Type> rowTypes, int[] maxCardinalities, int totalEntries) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
        Block elementBlock = columnarArray.getElementsBlock();
        List fields = RowBlock.getRowFieldsFromBlock((Block)elementBlock);
        Block[] blocks = new Block[fields.size()];
        int positionCount = block.getPositionCount();
        for (int i = 0; i < fields.size(); ++i) {
            BlockBuilder blockBuilder = rowTypes.get(i).createBlockBuilder(null, totalEntries);
            for (int j = 0; j < positionCount; ++j) {
                int rowBlockIndex = columnarArray.getOffset(j);
                int cardinality = columnarArray.getLength(j);
                for (int k = 0; k < cardinality; ++k) {
                    rowTypes.get(i).appendTo((Block)fields.get(i), rowBlockIndex + k, blockBuilder);
                }
                int maxCardinality = maxCardinalities[j];
                for (int k = cardinality; k < maxCardinality; ++k) {
                    blockBuilder.appendNull();
                }
            }
            blocks[i] = blockBuilder.build();
        }
        return blocks;
    }

    private static Block buildExpectedOrdinalityBlock(UnnestedLengths unnestedLengths, int totalEntries) {
        int[] maxCardinalities = unnestedLengths.getMaxCardinalities();
        BlockBuilder ordinalityBlockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(totalEntries);
        for (int i = 0; i < maxCardinalities.length; ++i) {
            int maxCardinality = maxCardinalities[i];
            if (maxCardinality == 1 && unnestedLengths.isNullAppendForOuter(i)) {
                ordinalityBlockBuilder.appendNull();
                continue;
            }
            for (int ordinalityCount = 1; ordinalityCount <= maxCardinality; ++ordinalityCount) {
                BigintType.BIGINT.writeLong(ordinalityBlockBuilder, (long)ordinalityCount);
            }
        }
        return ordinalityBlockBuilder.build();
    }

    static class UnnestedLengths {
        private final int[] maxCardinalities;
        private final Optional<boolean[]> nullAppendForOuter;

        public UnnestedLengths(int[] maxCardinalities, Optional<boolean[]> nullAppendForOuter) {
            this.maxCardinalities = Objects.requireNonNull(maxCardinalities, "maxCardinalities is null");
            this.nullAppendForOuter = Objects.requireNonNull(nullAppendForOuter, "nullAppendForOuter is null");
            nullAppendForOuter.ifPresent(booleans -> Preconditions.checkArgument((maxCardinalities.length == ((boolean[])booleans).length ? 1 : 0) != 0));
        }

        public int[] getMaxCardinalities() {
            return this.maxCardinalities;
        }

        public boolean isNullAppendForOuter(int position) {
            if (this.nullAppendForOuter.isEmpty()) {
                return false;
            }
            Preconditions.checkArgument((position >= 0 && position < this.nullAppendForOuter.get().length ? 1 : 0) != 0);
            return this.nullAppendForOuter.get()[position];
        }
    }
}

