/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.secrets.SecretsResolver;
import io.airlift.testing.TempFile;
import io.trino.security.GroupProviderManager;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.GroupProviderFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGroupProviderManager {
    private static final GroupProvider TEST_GROUP_PROVIDER = user -> ImmutableSet.of((Object)"test", (Object)user);
    private static final GroupProviderFactory TEST_GROUP_PROVIDER_FACTORY = new GroupProviderFactory(){

        public String getName() {
            return "testGroupProvider";
        }

        public GroupProvider create(Map<String, String> config) {
            return TEST_GROUP_PROVIDER;
        }
    };

    @Test
    public void testGroupProviderIsLoaded() throws IOException {
        try (TempFile tempFile = new TempFile();){
            Files.write(tempFile.path(), "group-provider.name=testGroupProvider".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            GroupProviderManager groupProviderManager = new GroupProviderManager(new SecretsResolver((Map)ImmutableMap.of()));
            groupProviderManager.addGroupProviderFactory(TEST_GROUP_PROVIDER_FACTORY);
            groupProviderManager.loadConfiguredGroupProvider(tempFile.file());
            Assertions.assertThat((Collection)groupProviderManager.getGroups("alice")).isEqualTo((Object)ImmutableSet.of((Object)"test", (Object)"alice"));
            Assertions.assertThat((Collection)groupProviderManager.getGroups("bob")).isEqualTo((Object)ImmutableSet.of((Object)"test", (Object)"bob"));
        }
    }
}

