/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.server.protocol.spooling.SpooledMetadataBlock;
import io.trino.server.protocol.spooling.SpooledMetadataBlockSerde;
import io.trino.spi.Page;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class TestSpooledMetadataBlockSerde {
    TestSpooledMetadataBlockSerde() {
    }

    @Test
    public void testSerializationRoundTrip() {
        this.verifySerialization(Slices.utf8Slice((String)"identifier"), Optional.of(URI.create("https://example.com/presigned")), (Map<String, List<String>>)ImmutableMap.of((Object)"X-Header", (Object)ImmutableList.of((Object)"value1", (Object)"value2")));
        this.verifySerialization(Slices.utf8Slice((String)"identifier"), Optional.empty(), (Map<String, List<String>>)ImmutableMap.of((Object)"X-Header", (Object)ImmutableList.of((Object)"value1", (Object)"value2")));
    }

    public void verifySerialization(Slice identifier, Optional<URI> directUri, Map<String, List<String>> headers) {
        this.verifySerializationRoundTrip(identifier, directUri, headers);
        this.verifySerializationRoundTripWithNonEmptyPage(identifier, directUri, headers);
    }

    public void verifySerializationRoundTrip(Slice identifier, Optional<URI> directUri, Map<String, List<String>> headers) {
        SpooledMetadataBlock.Spooled metadata = new SpooledMetadataBlock.Spooled(TestSpooledMetadataBlockSerde.createDataAttributes(10L, 1200), identifier, directUri, headers);
        AssertionsForClassTypes.assertThat((Object)metadata).isEqualTo((Object)SpooledMetadataBlockSerde.deserialize((Page)metadata.serialize()));
    }

    private void verifySerializationRoundTripWithNonEmptyPage(Slice identifier, Optional<URI> directUri, Map<String, List<String>> headers) {
        SpooledMetadataBlock.Spooled metadata = new SpooledMetadataBlock.Spooled(TestSpooledMetadataBlockSerde.createDataAttributes(10L, 1100), identifier, directUri, headers);
        AssertionsForClassTypes.assertThat((Object)metadata).isEqualTo((Object)SpooledMetadataBlockSerde.deserialize((Page)metadata.serialize()));
    }

    private static DataAttributes createDataAttributes(long rows, int segmentSize) {
        return DataAttributes.builder().set(DataAttribute.ROWS_COUNT, (Object)rows).set(DataAttribute.SEGMENT_SIZE, (Object)segmentSize).build();
    }
}

