/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.server.security.SecurityConfig;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestSecurityConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((SecurityConfig)ConfigAssertions.recordDefaults(SecurityConfig.class)).setAuthenticationTypes((List)ImmutableList.of((Object)"insecure")).setInsecureAuthenticationOverHttpAllowed(true).setFixedManagementUser(null).setFixedManagementUserForHttps(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"http-server.authentication.type", (Object)"KERBEROS,PASSWORD").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"false").put((Object)"management.user", (Object)"management-user").put((Object)"management.user.https-enabled", (Object)"true").buildOrThrow();
        SecurityConfig expected = new SecurityConfig().setAuthenticationTypes((List)ImmutableList.of((Object)"KERBEROS", (Object)"PASSWORD")).setInsecureAuthenticationOverHttpAllowed(false).setFixedManagementUser("management-user").setFixedManagementUserForHttps(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

