/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import io.trino.SequencePageBuilder;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.index.PageRecordSet;
import io.trino.operator.project.CursorProcessor;
import io.trino.operator.project.CursorProcessorOutput;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.CursorProcessorCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.testing.TestingConnectorSession;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TestCursorProcessorCompiler {
    TestCursorProcessorCompiler() {
    }

    @Test
    void testHugeNumberOfProjections() {
        CursorProcessorOutput processorOutput;
        int projectionCount = 10000;
        int positionCount = 512;
        long constantValue = 10L;
        TestingFunctionResolution functionResolution = new TestingFunctionResolution();
        CallExpression addConstantExpression = Expressions.call((ResolvedFunction)functionResolution.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)constantValue, (Type)BigintType.BIGINT)});
        CursorProcessorCompiler cursorProcessorCompiler = functionResolution.getCursorProcessorCompiler();
        Supplier cursorProcessorSupplier = cursorProcessorCompiler.compileCursorProcessor(Optional.empty(), Collections.nCopies(projectionCount, addConstantExpression), (Object)"key");
        CursorProcessor cursorProcessor = (CursorProcessor)cursorProcessorSupplier.get();
        ImmutableList inputTypes = ImmutableList.of((Object)BigintType.BIGINT);
        List<BigintType> outputTypes = Collections.nCopies(projectionCount, BigintType.BIGINT);
        Page inputPage = SequencePageBuilder.createSequencePage((List<? extends Type>)inputTypes, positionCount);
        Block inputBlock = inputPage.getBlock(0);
        RecordCursor cursor = new PageRecordSet((List)inputTypes, inputPage).cursor();
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        PageBuilder outputPageBuilder = new PageBuilder(outputTypes);
        int processedPositions = 0;
        do {
            processorOutput = cursorProcessor.process(TestingConnectorSession.SESSION, yieldSignal, cursor, outputPageBuilder);
            Page outputPage = outputPageBuilder.build();
            outputPageBuilder.reset();
            Assertions.assertThat((int)outputPage.getChannelCount()).isEqualTo(projectionCount);
            for (int channel = 0; channel < outputPage.getChannelCount(); ++channel) {
                Block outputBlock = outputPage.getBlock(channel);
                for (int position = 0; position < outputBlock.getPositionCount(); ++position) {
                    long input = BigintType.BIGINT.getLong(inputBlock, processedPositions + position);
                    long output = BigintType.BIGINT.getLong(outputBlock, position);
                    Assertions.assertThat((long)output).isEqualTo(input + constantValue);
                }
            }
            processedPositions += outputPage.getPositionCount();
        } while (!processorOutput.isNoMoreRows());
        Assertions.assertThat((int)processedPositions).isEqualTo(positionCount);
    }
}

