/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.SortItem;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestWindowClause
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction SUBTRACT_INTEGER = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction ADD_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    private static final ResolvedFunction NEGATION_INTEGER = FUNCTIONS.resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER));

    @Test
    public void testPreprojectExpression() {
        String sql = "SELECT max(b) OVER w FROM (VALUES (1, 1)) t(a, b) WINDOW w AS (PARTITION BY a + 1)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"expr"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("max_result", PlanMatchPattern.windowFunction("max", (List<String>)ImmutableList.of((Object)"b"), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.anyTree(PlanMatchPattern.values("a", "b"))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testPreprojectExpressions() {
        String sql = "SELECT max(b) OVER w3 FROM (VALUES (1, 1, 1)) t(a, b, c) WINDOW w1 AS (PARTITION BY a + 1), w2 AS (w1 ORDER BY b + 2), w3 AS (w2 RANGE c + 3 PRECEDING)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"expr_a"), (List<String>)ImmutableList.of((Object)"expr_b"), (Map<String, SortOrder>)ImmutableMap.of((Object)"expr_b", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("max_result", PlanMatchPattern.windowFunction("max", (List<String>)ImmutableList.of((Object)"b"), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.PRECEDING, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "frame_start")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "expr_b")), FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty()))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start", (Object)PlanMatchPattern.expression((Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "expr_b"), (Object)new Reference((Type)IntegerType.INTEGER, "expr_c"))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_a", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (Object)"expr_b", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "b"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))), (Object)"expr_c", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "c"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L))))), PlanMatchPattern.anyTree(PlanMatchPattern.values("a", "b", "c")))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testWindowFunctionsInSelectAndOrderBy() {
        String sql = "SELECT array_agg(a) OVER (w ORDER BY a + 1), -a a FROM (VALUES 1, 2, 3) t(a) WINDOW w AS () ORDER BY max(a) OVER (w ORDER BY a + 1)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("max_result", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), PlanMatchPattern.any(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"order_by_window_sortkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"order_by_window_sortkey", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("max_result", PlanMatchPattern.windowFunction("max", (List<String>)ImmutableList.of((Object)"minus_a"), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"order_by_window_sortkey", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "minus_a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"minus_a", (Object)PlanMatchPattern.expression((Expression)new Call(NEGATION_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"))))), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"select_window_sortkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"select_window_sortkey", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.windowFunction("array_agg", (List<String>)ImmutableList.of((Object)"a"), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"select_window_sortkey", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.anyTree(PlanMatchPattern.values("a"))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testWindowWithFrameCoercions() {
        String sql = "SELECT a old_a, 2e0 a FROM (VALUES -100, -99, -98) t(a) WINDOW w AS (ORDER BY a + 1) ORDER BY count(*) OVER (w RANGE BETWEEN CURRENT ROW AND a + 1e0 FOLLOWING)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("count_result", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"sortkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"sortkey", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("count_result", PlanMatchPattern.windowFunction("count", (List<String>)ImmutableList.of(), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.FOLLOWING, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "frame_bound")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "coerced_sortkey"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_bound", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_DOUBLE, (List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "coerced_sortkey"), (Object)new Reference((Type)DoubleType.DOUBLE, "frame_offset"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"coerced_sortkey", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)IntegerType.INTEGER, "sortkey"), (Type)DoubleType.DOUBLE))), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sortkey", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "a"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (Object)"frame_offset", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_DOUBLE, (List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "new_a"), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_a", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)2.0))), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.values("a")))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testPreservationOfWindowFunctionOrder() {
        String sql = "WITH data AS (\n    SELECT *\n    FROM (VALUES\n        ('A', 1, 100, 25),\n        ('A', 2, 200, 25),\n        ('A', 1, 150, 50),\n        ('B', 1, 300, 50),\n        ('B', 2, 100, 100),\n        ('B', 1, 200, 100)\n    ) AS t(category, subcategory, value, subvalue)\n)\nSELECT\n    RANK() OVER (\n        PARTITION BY category\n    ) AS rank_by_category,\n    RANK() OVER (\n        PARTITION BY category, subcategory\n    ) AS rank_by_category_subcategory,\n    RANK() OVER (\n        PARTITION BY category, subcategory, value\n    ) AS rank_by_category_subcategory_value,\n    RANK() OVER (\n        PARTITION BY category, subcategory, value, subvalue\n    ) AS rank_by_category_subcategory_value_subvalue\nFROM data\n";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"category", (Object)"subcategory", (Object)"value", (Object)"subvalue"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("rank_4", PlanMatchPattern.windowFunction("rank", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"category", (Object)"subcategory", (Object)"value"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("rank_3", PlanMatchPattern.windowFunction("rank", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"category", (Object)"subcategory"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("rank_2", PlanMatchPattern.windowFunction("rank", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"category"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("rank", PlanMatchPattern.windowFunction("rank", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(PlanMatchPattern.values("category", "subcategory", "value", "subvalue"))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }
}

