/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.assertions.SymbolAlias;
import io.trino.sql.planner.assertions.SymbolAliases;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class AggregationFunctionProvider
implements ExpectedValueProvider<AggregationFunction> {
    private final String name;
    private final boolean distinct;
    private final List<PlanTestSymbol> args;
    private final List<PlanMatchPattern.Ordering> orderBy;
    private final Optional<SymbolAlias> filter;

    public AggregationFunctionProvider(String name, boolean distinct, List<PlanTestSymbol> args, List<PlanMatchPattern.Ordering> orderBy, Optional<SymbolAlias> filter) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.distinct = distinct;
        this.args = Objects.requireNonNull(args, "args is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
    }

    public String toString() {
        return String.format("%s (%s%s) %s %s", this.name, this.distinct ? "DISTINCT" : "", Joiner.on((String)", ").join(this.args), this.orderBy.isEmpty() ? "" : " ORDER BY " + Joiner.on((String)", ").join(this.orderBy), this.filter.isPresent() ? this.filter.get().toString() : "");
    }

    @Override
    public AggregationFunction getExpectedValue(SymbolAliases aliases) {
        List<Expression> symbolReferences = PlanMatchPattern.toSymbolReferences(this.args, aliases);
        Optional<OrderingScheme> orderingScheme = Optional.empty();
        if (!this.orderBy.isEmpty()) {
            ImmutableList.Builder fields = ImmutableList.builder();
            ImmutableMap.Builder orders = ImmutableMap.builder();
            for (PlanMatchPattern.Ordering ordering : this.orderBy) {
                Reference reference = aliases.get(ordering.getField());
                Symbol symbol2 = new Symbol(reference.type(), reference.name());
                fields.add((Object)symbol2);
                orders.put((Object)symbol2, (Object)ordering.getSortOrder());
            }
            orderingScheme = Optional.of(new OrderingScheme((List)fields.build(), (Map)orders.buildOrThrow()));
        }
        return new AggregationFunction(this.name, this.filter.map(symbol -> symbol.toSymbol(aliases)), orderingScheme, this.distinct, symbolReferences);
    }
}

