/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ColumnHandleMatcher
implements RvalueMatcher {
    private final Predicate<ColumnHandle> matcher;

    public ColumnHandleMatcher(Predicate<ColumnHandle> handleMatcher) {
        this.matcher = Objects.requireNonNull(handleMatcher, "handleMatcher is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        if (!(node instanceof TableScanNode)) {
            return Optional.empty();
        }
        TableScanNode tableScanNode = (TableScanNode)node;
        Map assignments = tableScanNode.getAssignments();
        for (Map.Entry entry : assignments.entrySet()) {
            if (!this.matcher.test((ColumnHandle)entry.getValue())) continue;
            return Optional.of((Symbol)entry.getKey());
        }
        return Optional.empty();
    }
}

