/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Objects;

public class CorrelationMatcher
implements Matcher {
    private final List<String> correlation;

    CorrelationMatcher(List<String> correlation) {
        this.correlation = Objects.requireNonNull(correlation, "correlation is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof ApplyNode || node instanceof CorrelatedJoinNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        List<Symbol> actualCorrelation = this.getCorrelation(node);
        if (this.correlation.size() != actualCorrelation.size()) {
            return MatchResult.NO_MATCH;
        }
        int i = 0;
        for (String alias : this.correlation) {
            if (symbolAliases.get(alias).equals((Object)actualCorrelation.get(i++).toSymbolReference())) continue;
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    private List<Symbol> getCorrelation(PlanNode node) {
        if (node instanceof ApplyNode) {
            ApplyNode applyNode = (ApplyNode)node;
            return applyNode.getCorrelation();
        }
        if (node instanceof CorrelatedJoinNode) {
            CorrelatedJoinNode correlatedJoinNode = (CorrelatedJoinNode)node;
            return correlatedJoinNode.getCorrelation();
        }
        throw new IllegalStateException("Unexpected plan node: " + String.valueOf(node));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("correlation", this.correlation).toString();
    }
}

