/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.Session;
import io.trino.cost.CachingStatsProvider;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsProvider;
import io.trino.cost.TableStatsProvider;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanMatchingVisitor;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Plans;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.planprinter.PlanPrinter;
import java.util.stream.Stream;

public final class PlanAssert {
    private PlanAssert() {
    }

    public static void assertPlan(Session session, Metadata metadata, FunctionManager functionManager, StatsCalculator statsCalculator, Plan actual, PlanMatchPattern pattern) {
        PlanAssert.assertPlan(session, metadata, functionManager, statsCalculator, actual, Lookup.noLookup(), pattern);
    }

    public static void assertPlan(Session session, Metadata metadata, FunctionManager functionManager, StatsCalculator statsCalculator, Plan actual, Lookup lookup, PlanMatchPattern pattern) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, session, (TableStatsProvider)new CachingTableStatsProvider(metadata, session));
        PlanAssert.assertPlan(session, metadata, functionManager, (StatsProvider)statsProvider, actual, lookup, pattern);
    }

    public static void assertPlan(Session session, Metadata metadata, FunctionManager functionManager, StatsProvider statsProvider, Plan actual, Lookup lookup, PlanMatchPattern pattern) {
        MatchResult matches = (MatchResult)actual.getRoot().accept((PlanVisitor)new PlanMatchingVisitor(session, metadata, statsProvider, lookup), (Object)pattern);
        if (!matches.isMatch()) {
            String formattedPlan = PlanPrinter.textLogicalPlan((PlanNode)actual.getRoot(), (Metadata)metadata, (FunctionManager)functionManager, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)0, (boolean)false);
            if (!PlanAssert.containsGroupReferences(actual.getRoot())) {
                throw new AssertionError((Object)String.format("Plan does not match, expected [\n\n%s\n] but found [\n\n%s\n]", pattern, formattedPlan));
            }
            PlanNode resolvedPlan = Plans.resolveGroupReferences((PlanNode)actual.getRoot(), (Lookup)lookup);
            String resolvedFormattedPlan = PlanPrinter.textLogicalPlan((PlanNode)resolvedPlan, (Metadata)metadata, (FunctionManager)functionManager, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)0, (boolean)false);
            throw new AssertionError((Object)String.format("Plan does not match, expected [\n\n%s\n] but found [\n\n%s\n] which resolves to [\n\n%s\n]", pattern, formattedPlan, resolvedFormattedPlan));
        }
    }

    private static boolean containsGroupReferences(PlanNode node) {
        return PlanNodeSearcher.searchFrom((PlanNode)node, (Lookup)Lookup.from(Stream::of)).where(GroupReference.class::isInstance).findFirst().isPresent();
    }
}

