/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestMetadataManager;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneOrderByInWindowAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneOrderByInWindowAggregation
extends BaseRuleTest {
    private static final Metadata METADATA = TestMetadataManager.createTestMetadataManager();

    public TestPruneOrderByInWindowAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testBasics() {
        this.tester().assertThat((Rule<?>)new PruneOrderByInWindowAggregation(METADATA)).on(planBuilder -> {
            Symbol avg = planBuilder.symbol("avg");
            Symbol arrayAgg = planBuilder.symbol("araray_agg");
            Symbol input = planBuilder.symbol("input");
            Symbol key = planBuilder.symbol("key");
            Symbol keyHash = planBuilder.symbol("keyHash");
            Symbol mask = planBuilder.symbol("mask");
            ImmutableList sourceSymbols = ImmutableList.of((Object)input, (Object)key, (Object)keyHash, (Object)mask);
            ResolvedFunction avgFunction = METADATA.resolveBuiltinFunction("avg", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
            ResolvedFunction arrayAggFunction = METADATA.resolveBuiltinFunction("array_agg", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
            return planBuilder.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)planBuilder.symbol("key", (Type)BigintType.BIGINT)), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)avg, (Object)new WindowNode.Function(avgFunction, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input")), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "input")), (Map)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "input"), (Object)SortOrder.ASC_NULLS_LAST))), WindowNode.Frame.DEFAULT_FRAME, false, false), (Object)arrayAgg, (Object)new WindowNode.Function(arrayAggFunction, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input")), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "input")), (Map)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "input"), (Object)SortOrder.ASC_NULLS_LAST))), WindowNode.Frame.DEFAULT_FRAME, false, false)), (PlanNode)planBuilder.values((List<Symbol>)sourceSymbols, (List<List<Expression>>)ImmutableList.of()));
        }).matches(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"key"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("avg", PlanMatchPattern.windowFunction("avg", (List<String>)ImmutableList.of((Object)"input"), WindowNode.Frame.DEFAULT_FRAME)).addFunction("array_agg", PlanMatchPattern.windowFunction("array_agg", (List<String>)ImmutableList.of((Object)"input"), WindowNode.Frame.DEFAULT_FRAME, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("input", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)))), PlanMatchPattern.values("input", "key", "keyHash", "mask")));
    }
}

