/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestValues {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testRowSpecifications() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 2"))).matches("VALUES ROW(1), ROW(2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES (1, 'a')"))).matches("VALUES ROW(1, 'a')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, 'TruE') AS row(double, boolean))"))).matches("VALUES ROW(1e0, true)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, 'TruE') AS row(double, boolean)), ROW(2e0, false), (3e0, null)"))).matches("VALUES ROW(1e0, true),ROW(2e0, false), ROW(3e0, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT key FROM (VALUES CAST(ROW(1, 'TruE') AS row(double, boolean)), ROW(2e0, false), (3e0, null)) T(key, value)"))).matches("VALUES 1e0, 2e0, 3e0");
    }

    @Test
    public void testCoercions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 2e0"))).matches("VALUES ROW(1e0), ROW(2e0)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES (1, 2), (3, 4e0)"))).matches("VALUES ROW(1, 2e0), ROW(3, 4e0)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, 2) AS row(integer, smallint)), (3, 4e0)"))).matches("VALUES ROW(1, 2e0), ROW(3, 4e0)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, 2) AS row(integer, double)), (3, 4)"))).matches("VALUES ROW(1, 2e0), ROW(3, 4e0)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, null) AS row(integer, double)), (3, 4)"))).matches("VALUES ROW(1, null), ROW(3, 4e0)");
    }

    @Test
    public void testNulls() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES null"))).matches("VALUES ROW(null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES (null, null)"))).matches("VALUES ROW(null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES (null, null), ('a', 'b')"))).matches("VALUES ROW(null, null), ROW('a', 'b')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(null, null) AS row(real, double)), (1, 1)"))).matches("VALUES ROW(null, null), ROW(REAL '1', DOUBLE '1')");
    }

    @Test
    public void testFailingExpression() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 0 / 0"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES CASE 1 WHEN 0 THEN true WHEN 0 / 0 THEN false END"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES IF(0 / 0 > 0, true, false)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }
}

