/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.assertions;

import io.trino.execution.ExecutionFailureInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.testing.QueryFailedException;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.util.Failures;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTrinoExceptionAssert {
    @Test
    public void testCatchTrinoException() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "test exception");
        }).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("test exception");
    }

    @Test
    public void testCatchRemoteTrinoException() {
        ExecutionFailureInfo failureInfo = Failures.toFailure((Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "remote exception"));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> {
            throw new QueryFailedException(new QueryId("test"), failureInfo.getMessage(), (Throwable)failureInfo.toException());
        }).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("remote exception");
    }

    @Test
    public void testRejectRuntimeException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> {
            throw new RuntimeException("not a trino exception");
        })).isInstanceOf(AssertionError.class)).hasMessage("Expected TrinoException or wrapper, but got: java.lang.RuntimeException java.lang.RuntimeException: not a trino exception");
    }

    @Test
    public void testRejectRemoteRuntimeException() {
        ExecutionFailureInfo failureInfo = Failures.toFailure((Throwable)new RuntimeException("not a trino exception"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> {
            throw new QueryFailedException(new QueryId("test"), failureInfo.getMessage(), (Throwable)failureInfo.toException());
        })).isInstanceOf(AssertionError.class)).hasMessage("Expected TrinoException or wrapper, but got: io.trino.testing.QueryFailedException io.trino.testing.QueryFailedException: not a trino exception");
    }

    @Test
    public void testRejectWeirdRemoteTrinoException() {
        TrinoException trinoException = new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "test exception");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> {
            throw new QueryFailedException(new QueryId("test"), trinoException.getMessage(), (Throwable)trinoException);
        })).isInstanceOf(AssertionError.class)).hasMessage("Expected TrinoException or wrapper, but got: io.trino.testing.QueryFailedException io.trino.testing.QueryFailedException: test exception");
    }
}

