/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.trino.SessionRepresentation;
import io.trino.client.NodeVersion;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.Input;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStats;
import io.trino.execution.StageInfo;
import io.trino.operator.RetryPolicy;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorType;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoWarning;
import io.trino.spi.eventlistener.RoutineInfo;
import io.trino.spi.eventlistener.TableInfo;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.SelectedRole;
import io.trino.sql.analyzer.Output;
import io.trino.transaction.TransactionId;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;

@Immutable
public class QueryInfo {
    private final QueryId queryId;
    private final SessionRepresentation session;
    private final QueryState state;
    private final URI self;
    private final List<String> fieldNames;
    private final String query;
    private final Optional<String> preparedQuery;
    private final QueryStats queryStats;
    private final Optional<String> setCatalog;
    private final Optional<String> setSchema;
    private final Optional<String> setPath;
    private final Optional<String> setAuthorizationUser;
    private final boolean resetAuthorizationUser;
    private final Set<SelectedRole> setOriginalRoles;
    private final Map<String, String> setSessionProperties;
    private final Set<String> resetSessionProperties;
    private final Map<String, SelectedRole> setRoles;
    private final Map<String, String> addedPreparedStatements;
    private final Set<String> deallocatedPreparedStatements;
    private final Optional<TransactionId> startedTransactionId;
    private final boolean clearTransactionId;
    private final String updateType;
    private final Optional<StageInfo> outputStage;
    private final List<TableInfo> referencedTables;
    private final List<RoutineInfo> routines;
    private final ExecutionFailureInfo failureInfo;
    private final ErrorType errorType;
    private final ErrorCode errorCode;
    private final List<TrinoWarning> warnings;
    private final Set<Input> inputs;
    private final Optional<Output> output;
    private final boolean finalQueryInfo;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final Optional<QueryType> queryType;
    private final RetryPolicy retryPolicy;
    private final boolean pruned;
    private final NodeVersion version;

    @JsonCreator
    public QueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="state") QueryState state, @JsonProperty(value="self") URI self, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="query") String query, @JsonProperty(value="preparedQuery") Optional<String> preparedQuery, @JsonProperty(value="queryStats") QueryStats queryStats, @JsonProperty(value="setCatalog") Optional<String> setCatalog, @JsonProperty(value="setSchema") Optional<String> setSchema, @JsonProperty(value="setPath") Optional<String> setPath, @JsonProperty(value="setAuthorizationUser") Optional<String> setAuthorizationUser, @JsonProperty(value="resetAuthorizationUser") boolean resetAuthorizationUser, @JsonProperty(value="setOriginalRoles") Set<SelectedRole> setOriginalRoles, @JsonProperty(value="setSessionProperties") Map<String, String> setSessionProperties, @JsonProperty(value="resetSessionProperties") Set<String> resetSessionProperties, @JsonProperty(value="setRoles") Map<String, SelectedRole> setRoles, @JsonProperty(value="addedPreparedStatements") Map<String, String> addedPreparedStatements, @JsonProperty(value="deallocatedPreparedStatements") Set<String> deallocatedPreparedStatements, @JsonProperty(value="startedTransactionId") Optional<TransactionId> startedTransactionId, @JsonProperty(value="clearTransactionId") boolean clearTransactionId, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="outputStage") Optional<StageInfo> outputStage, @JsonProperty(value="failureInfo") ExecutionFailureInfo failureInfo, @JsonProperty(value="errorCode") ErrorCode errorCode, @JsonProperty(value="warnings") List<TrinoWarning> warnings, @JsonProperty(value="inputs") Set<Input> inputs, @JsonProperty(value="output") Optional<Output> output, @JsonProperty(value="referencedTables") List<TableInfo> referencedTables, @JsonProperty(value="routines") List<RoutineInfo> routines, @JsonProperty(value="finalQueryInfo") boolean finalQueryInfo, @JsonProperty(value="resourceGroupId") Optional<ResourceGroupId> resourceGroupId, @JsonProperty(value="queryType") Optional<QueryType> queryType, @JsonProperty(value="retryPolicy") RetryPolicy retryPolicy, @JsonProperty(value="pruned") boolean pruned, @JsonProperty(value="version") NodeVersion version) {
        Objects.requireNonNull(queryId, "queryId is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(self, "self is null");
        Objects.requireNonNull(fieldNames, "fieldNames is null");
        Objects.requireNonNull(queryStats, "queryStats is null");
        Objects.requireNonNull(setCatalog, "setCatalog is null");
        Objects.requireNonNull(setSchema, "setSchema is null");
        Objects.requireNonNull(setPath, "setPath is null");
        Objects.requireNonNull(setAuthorizationUser, "setAuthorizationUser is null");
        Objects.requireNonNull(setOriginalRoles, "setOriginalRoles is null");
        Objects.requireNonNull(setSessionProperties, "setSessionProperties is null");
        Objects.requireNonNull(resetSessionProperties, "resetSessionProperties is null");
        Objects.requireNonNull(addedPreparedStatements, "addedPreparedStatements is null");
        Objects.requireNonNull(deallocatedPreparedStatements, "deallocatedPreparedStatements is null");
        Objects.requireNonNull(startedTransactionId, "startedTransactionId is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        Objects.requireNonNull(outputStage, "outputStage is null");
        Objects.requireNonNull(inputs, "inputs is null");
        Objects.requireNonNull(output, "output is null");
        Objects.requireNonNull(referencedTables, "referencedTables is null");
        Objects.requireNonNull(routines, "routines is null");
        Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        Objects.requireNonNull(warnings, "warnings is null");
        Objects.requireNonNull(queryType, "queryType is null");
        Objects.requireNonNull(retryPolicy, "retryPolicy is null");
        Objects.requireNonNull(version, "version is null");
        this.queryId = queryId;
        this.session = session;
        this.state = state;
        this.self = self;
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.query = query;
        this.preparedQuery = preparedQuery;
        this.queryStats = queryStats;
        this.setCatalog = setCatalog;
        this.setSchema = setSchema;
        this.setPath = setPath;
        this.setAuthorizationUser = setAuthorizationUser;
        this.resetAuthorizationUser = resetAuthorizationUser;
        this.setOriginalRoles = setOriginalRoles;
        this.setSessionProperties = ImmutableMap.copyOf(setSessionProperties);
        this.resetSessionProperties = ImmutableSet.copyOf(resetSessionProperties);
        this.setRoles = ImmutableMap.copyOf(setRoles);
        this.addedPreparedStatements = ImmutableMap.copyOf(addedPreparedStatements);
        this.deallocatedPreparedStatements = ImmutableSet.copyOf(deallocatedPreparedStatements);
        this.startedTransactionId = startedTransactionId;
        this.clearTransactionId = clearTransactionId;
        this.updateType = updateType;
        this.outputStage = outputStage;
        this.failureInfo = failureInfo;
        this.errorType = errorCode == null ? null : errorCode.getType();
        this.errorCode = errorCode;
        this.warnings = ImmutableList.copyOf(warnings);
        this.inputs = ImmutableSet.copyOf(inputs);
        this.output = output;
        this.referencedTables = ImmutableList.copyOf(referencedTables);
        this.routines = ImmutableList.copyOf(routines);
        this.finalQueryInfo = finalQueryInfo;
        Preconditions.checkArgument((!finalQueryInfo || state.isDone() ? 1 : 0) != 0, (Object)"finalQueryInfo without a terminal query state");
        this.resourceGroupId = resourceGroupId;
        this.queryType = queryType;
        this.retryPolicy = retryPolicy;
        this.pruned = pruned;
        this.version = version;
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.queryStats.isScheduled();
    }

    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        return this.queryStats.getProgressPercentage();
    }

    @JsonProperty
    public OptionalDouble getRunningPercentage() {
        return this.queryStats.getRunningPercentage();
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public Optional<String> getPreparedQuery() {
        return this.preparedQuery;
    }

    @JsonProperty
    public QueryStats getQueryStats() {
        return this.queryStats;
    }

    @JsonProperty
    public Optional<String> getSetCatalog() {
        return this.setCatalog;
    }

    @JsonProperty
    public Optional<String> getSetSchema() {
        return this.setSchema;
    }

    @JsonProperty
    public Optional<String> getSetPath() {
        return this.setPath;
    }

    @JsonProperty
    public Optional<String> getSetAuthorizationUser() {
        return this.setAuthorizationUser;
    }

    @JsonProperty
    public boolean isResetAuthorizationUser() {
        return this.resetAuthorizationUser;
    }

    @JsonProperty
    public Set<SelectedRole> getSetOriginalRoles() {
        return this.setOriginalRoles;
    }

    @JsonProperty
    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    @JsonProperty
    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    @JsonProperty
    public Map<String, SelectedRole> getSetRoles() {
        return this.setRoles;
    }

    @JsonProperty
    public Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    @JsonProperty
    public Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    @JsonProperty
    public Optional<TransactionId> getStartedTransactionId() {
        return this.startedTransactionId;
    }

    @JsonProperty
    public boolean isClearTransactionId() {
        return this.clearTransactionId;
    }

    @Nullable
    @JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @JsonProperty
    public Optional<StageInfo> getOutputStage() {
        return this.outputStage;
    }

    @Nullable
    @JsonProperty
    public ExecutionFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    @Nullable
    @JsonProperty
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public List<TrinoWarning> getWarnings() {
        return this.warnings;
    }

    @JsonProperty
    public boolean isFinalQueryInfo() {
        return this.finalQueryInfo;
    }

    @JsonProperty
    public Set<Input> getInputs() {
        return this.inputs;
    }

    @JsonProperty
    public Optional<Output> getOutput() {
        return this.output;
    }

    @JsonProperty
    public List<TableInfo> getReferencedTables() {
        return this.referencedTables;
    }

    @JsonProperty
    public List<RoutineInfo> getRoutines() {
        return this.routines;
    }

    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    public Optional<QueryType> getQueryType() {
        return this.queryType;
    }

    @JsonProperty
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @JsonProperty
    public boolean isPruned() {
        return this.pruned;
    }

    @JsonProperty
    public NodeVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).add("fieldNames", this.fieldNames).toString();
    }

    public QueryInfo pruneDigests() {
        return new QueryInfo(this.queryId, this.session, this.state, this.self, this.fieldNames, this.query, this.preparedQuery, this.queryStats, this.setCatalog, this.setSchema, this.setPath, this.setAuthorizationUser, this.resetAuthorizationUser, this.setOriginalRoles, this.setSessionProperties, this.resetSessionProperties, this.setRoles, this.addedPreparedStatements, this.deallocatedPreparedStatements, this.startedTransactionId, this.clearTransactionId, this.updateType, this.outputStage.map(StageInfo::pruneDigests), this.failureInfo, this.errorCode, this.warnings, this.inputs, this.output, this.referencedTables, this.routines, this.finalQueryInfo, this.resourceGroupId, this.queryType, this.retryPolicy, this.pruned, this.version);
    }
}

