/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.trino.Session;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class TableInfo {
    private final Optional<String> connectorName;
    private final QualifiedObjectName tableName;
    private final TupleDomain<ColumnHandle> predicate;

    @JsonCreator
    public TableInfo(@JsonProperty(value="connectorName") Optional<String> connectorName, @JsonProperty(value="tableName") QualifiedObjectName tableName, @JsonProperty(value="predicate") TupleDomain<ColumnHandle> predicate) {
        this.connectorName = Objects.requireNonNull(connectorName, "connectorName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    @JsonProperty
    public Optional<String> getConnectorName() {
        return this.connectorName;
    }

    @JsonProperty
    public QualifiedObjectName getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getPredicate() {
        return this.predicate;
    }

    public static Map<PlanNodeId, TableInfo> extract(Session session, Metadata metadata, PlanFragment fragment) {
        return (Map)PlanNodeSearcher.searchFrom(fragment.getRoot()).where(TableScanNode.class::isInstance).findAll().stream().map(TableScanNode.class::cast).collect(ImmutableMap.toImmutableMap(PlanNode::getId, node -> TableInfo.extract(session, metadata, node)));
    }

    private static TableInfo extract(Session session, Metadata metadata, TableScanNode node) {
        CatalogSchemaTableName tableName = metadata.getTableName(session, node.getTable());
        TableProperties tableProperties = metadata.getTableProperties(session, node.getTable());
        Optional<String> connectorName = metadata.listCatalogs(session).stream().filter(catalogInfo -> catalogInfo.catalogName().equals(tableName.getCatalogName())).map(CatalogInfo::connectorName).map(ConnectorName::toString).findFirst();
        QualifiedObjectName objectName = new QualifiedObjectName(tableName.getCatalogName(), tableName.getSchemaTableName().getSchemaName(), tableName.getSchemaTableName().getTableName());
        return new TableInfo(connectorName, objectName, tableProperties.getPredicate());
    }
}

