/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DiscretePredicates;
import io.trino.spi.connector.LocalProperty;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.planner.PartitioningHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableProperties {
    private final ConnectorTableProperties tableProperties;
    private final CatalogHandle catalogHandle;
    private final ConnectorTransactionHandle transaction;

    public TableProperties(CatalogHandle catalogHandle, ConnectorTransactionHandle transaction, ConnectorTableProperties tableProperties) {
        Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        Objects.requireNonNull(transaction, "transaction is null");
        Objects.requireNonNull(tableProperties, "tableProperties is null");
        this.catalogHandle = catalogHandle;
        this.transaction = transaction;
        this.tableProperties = tableProperties;
    }

    public TupleDomain<ColumnHandle> getPredicate() {
        return this.tableProperties.getPredicate();
    }

    public List<LocalProperty<ColumnHandle>> getLocalProperties() {
        return this.tableProperties.getLocalProperties();
    }

    public Optional<TablePartitioning> getTablePartitioning() {
        return this.tableProperties.getTablePartitioning().map(nodePartitioning -> new TablePartitioning(new PartitioningHandle(Optional.of(this.catalogHandle), Optional.of(this.transaction), nodePartitioning.getPartitioningHandle()), nodePartitioning.getPartitioningColumns(), nodePartitioning.isSingleSplitPerPartition()));
    }

    public Optional<DiscretePredicates> getDiscretePredicates() {
        return this.tableProperties.getDiscretePredicates();
    }

    public record TablePartitioning(PartitioningHandle partitioningHandle, List<ColumnHandle> partitioningColumns, boolean singleSplitPerPartition) {
        public TablePartitioning {
            Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
            partitioningColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
        }
    }
}

