/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.PipelineContext;
import io.trino.operator.SpoolingController;
import io.trino.server.protocol.spooling.SpoolingSessionProperties;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class PipelineSpoolingController
implements SpoolingController {
    private final SpoolingController next;
    private final AtomicLong totalInlinedPositions;
    private final AtomicLong totalInlinedSize;
    private final boolean inliningEnabled;
    private final long inlinedPositions;
    private final long inlinedSize;
    private final SpoolingController.ActionMetrics inlined = new SpoolingController.ActionMetrics();

    public PipelineSpoolingController(PipelineContext context, SpoolingController next) {
        this(context.getInlinedPositions(), context.getInlinedSize(), SpoolingSessionProperties.isInliningEnabled(context.getSession()), SpoolingSessionProperties.getInliningMaxRows(context.getSession()), SpoolingSessionProperties.getInliningMaxSize(context.getSession()).toBytes(), next);
    }

    PipelineSpoolingController(AtomicLong totalInlinedPositions, AtomicLong totalInlinedSize, boolean inliningEnabled, long inlinedPositions, long inlinedSize, SpoolingController next) {
        this.inliningEnabled = inliningEnabled;
        this.inlinedPositions = inlinedPositions;
        this.inlinedSize = inlinedSize;
        this.totalInlinedPositions = Objects.requireNonNull(totalInlinedPositions, "totalInlinedPositions is null");
        this.totalInlinedSize = Objects.requireNonNull(totalInlinedSize, "totalInlinedSize is null");
        this.next = next;
    }

    @Override
    public SpoolingController.Mode nextMode(int positions, long size) {
        if (!this.inliningEnabled) {
            return this.next.nextMode(positions, size);
        }
        if (this.totalInlinedPositions.addAndGet(positions) > this.inlinedPositions) {
            return this.next.nextMode(positions, size);
        }
        if (this.totalInlinedSize.addAndGet(size) > this.inlinedSize) {
            return this.next.nextMode(positions, size);
        }
        return this.execute(SpoolingController.Mode.INLINE, positions, size);
    }

    @Override
    public <T extends SpoolingController> T unwrap(Class<T> clazz) {
        if (clazz.equals(PipelineSpoolingController.class)) {
            return (T)this;
        }
        return this.next.unwrap(clazz);
    }

    @Override
    public SpoolingController.Mode execute(SpoolingController.Mode mode, long positions, long size) {
        if (!this.inliningEnabled) {
            return this.next.execute(mode, positions, size);
        }
        switch (mode) {
            case BUFFER: 
            case SPOOL: {
                this.next.execute(mode, positions, size);
                break;
            }
            case INLINE: {
                this.inlined.recordPage(positions, size);
            }
        }
        return mode;
    }

    @Override
    public SpoolingController.MetricSnapshot getMetrics(SpoolingController.Mode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case SpoolingController.Mode.INLINE -> this.inlined.snapshot();
            case SpoolingController.Mode.BUFFER, SpoolingController.Mode.SPOOL -> this.next.getMetrics(mode);
        };
    }
}

