/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.MarkDistinctHash;
import io.trino.operator.PagesIndex;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.operator.window.PagesWindowIndex;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class DistinctWindowAccumulator
implements WindowAccumulator {
    private final WindowAccumulator delegate;
    private final List<Type> argumentTypes;
    private final List<Integer> argumentChannels;
    private final MarkDistinctHash hash;
    private final PageBuilder pageBuilder;
    private final PagesIndex.Factory pagesIndexFactory;

    public DistinctWindowAccumulator(WindowAccumulator delegate, List<Type> argumentTypes, List<Integer> argumentChannels, FlatHashStrategyCompiler hashStrategyCompiler, Session session, PagesIndex.Factory pagesIndexFactory) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.argumentTypes = ImmutableList.copyOf(argumentTypes);
        this.argumentChannels = ImmutableList.copyOf(argumentChannels);
        this.hash = new MarkDistinctHash(session, argumentTypes, false, hashStrategyCompiler, UpdateMemory.NOOP);
        this.pageBuilder = new PageBuilder(argumentTypes);
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
    }

    private DistinctWindowAccumulator(WindowAccumulator delegate, List<Type> argumentTypes, List<Integer> argumentChannels, MarkDistinctHash hash, PagesIndex.Factory pagesIndexFactory) {
        this.delegate = delegate;
        this.argumentTypes = argumentTypes;
        this.argumentChannels = argumentChannels;
        this.hash = hash;
        this.pageBuilder = new PageBuilder(argumentTypes);
        this.pagesIndexFactory = pagesIndexFactory;
    }

    public long getEstimatedSize() {
        return this.delegate.getEstimatedSize() + this.pageBuilder.getRetainedSizeInBytes() + this.hash.getEstimatedSize();
    }

    public WindowAccumulator copy() {
        Page page = this.pageBuilder.build();
        this.indexCurrentPage(page);
        this.pageBuilder.reset();
        return new DistinctWindowAccumulator(this.delegate.copy(), this.argumentTypes, this.argumentChannels, this.hash.copy(), this.pagesIndexFactory);
    }

    public void addInput(WindowIndex index, int startPosition, int endPosition) {
        for (int position = startPosition; position <= endPosition; ++position) {
            if (this.pageBuilder.isFull()) {
                Page page = this.pageBuilder.build();
                this.indexCurrentPage(page);
                this.pageBuilder.reset();
            }
            for (int channel = 0; channel < this.argumentChannels.size(); ++channel) {
                ValueBlock value = index.getSingleValueBlock(channel, position).getSingleValueBlock(0);
                this.pageBuilder.getBlockBuilder(channel).append(value, 0);
            }
            this.pageBuilder.declarePosition();
        }
    }

    private void indexCurrentPage(Page page) {
        int selectedPositionsCount;
        Work<Block> work = this.hash.markDistinctRows(page);
        Preconditions.checkState((boolean)work.process());
        Block distinctMask = work.getResult();
        int positionCount = distinctMask.getPositionCount();
        Preconditions.checkArgument((positionCount == page.getPositionCount() ? 1 : 0) != 0, (Object)"Page position count does not match distinct mask position count");
        PagesIndex pagesIndex = this.pagesIndexFactory.newPagesIndex(this.argumentTypes, positionCount);
        if (distinctMask instanceof RunLengthEncodedBlock) {
            if (DistinctWindowAccumulator.test(distinctMask, 0)) {
                pagesIndex.addPage(page);
            }
        } else {
            PageBuilder filteredPageBuilder = new PageBuilder(this.argumentTypes);
            for (int position = 0; position < positionCount; ++position) {
                if (!DistinctWindowAccumulator.test(distinctMask, position)) continue;
                for (int channel = 0; channel < this.argumentChannels.size(); ++channel) {
                    this.argumentTypes.get(channel).appendTo(page.getBlock(channel), position, filteredPageBuilder.getBlockBuilder(channel));
                }
                filteredPageBuilder.declarePosition();
            }
            pagesIndex.addPage(filteredPageBuilder.build());
        }
        if ((selectedPositionsCount = pagesIndex.getPositionCount()) > 0) {
            PagesWindowIndex selectedWindowIndex = new PagesWindowIndex(pagesIndex, 0, selectedPositionsCount);
            this.delegate.addInput((WindowIndex)selectedWindowIndex, 0, selectedPositionsCount - 1);
        }
    }

    private static boolean test(Block block, int position) {
        if (block.isNull(position)) {
            return false;
        }
        return BooleanType.BOOLEAN.getBoolean(block, position);
    }

    public void output(BlockBuilder blockBuilder) {
        if (!this.pageBuilder.isEmpty()) {
            Page page = this.pageBuilder.build();
            this.indexCurrentPage(page);
            this.pageBuilder.reset();
        }
        this.delegate.output(blockBuilder);
    }
}

