/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import io.trino.metadata.Split;
import io.trino.operator.DriverContext;
import io.trino.operator.FinishedOperator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorInfo;
import io.trino.operator.PageSourceOperator;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.operator.SplitOperatorInfo;
import io.trino.operator.index.IndexSplit;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorIndex;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class IndexSourceOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final ConnectorIndex index;
    private final Function<RecordSet, RecordSet> probeKeyNormalizer;
    private Operator source;

    public IndexSourceOperator(OperatorContext operatorContext, PlanNodeId planNodeId, ConnectorIndex index, Function<RecordSet, RecordSet> probeKeyNormalizer) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.probeKeyNormalizer = Objects.requireNonNull(probeKeyNormalizer, "probeKeyNormalizer is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public void addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkState((this.source == null ? 1 : 0) != 0, (Object)"Index source split already set");
        IndexSplit indexSplit = (IndexSplit)split.getConnectorSplit();
        RecordSet normalizedRecordSet = this.probeKeyNormalizer.apply(indexSplit.getKeyRecordSet());
        ConnectorPageSource result = this.index.lookup(normalizedRecordSet);
        this.source = new PageSourceOperator(result, this.operatorContext);
        Map<String, String> splitInfo = split.getInfo();
        if (!splitInfo.isEmpty()) {
            this.operatorContext.setInfoSupplier((Supplier<? extends OperatorInfo>)Suppliers.ofInstance((Object)new SplitOperatorInfo(split.getCatalogHandle(), splitInfo)));
        }
    }

    @Override
    public void noMoreSplits() {
        if (this.source == null) {
            this.source = new FinishedOperator(this.operatorContext);
        }
    }

    @Override
    public void finish() {
        this.noMoreSplits();
        this.source.finish();
    }

    @Override
    public boolean isFinished() {
        return this.source != null && this.source.isFinished();
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot take input");
    }

    @Override
    public Page getOutput() {
        if (this.source == null) {
            return null;
        }
        return this.source.getOutput();
    }

    @Override
    public void close() throws Exception {
        if (this.source != null) {
            this.source.close();
        }
    }

    public static class IndexSourceOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final ConnectorIndex index;
        private final Function<RecordSet, RecordSet> probeKeyNormalizer;
        private boolean closed;

        public IndexSourceOperatorFactory(int operatorId, PlanNodeId sourceId, ConnectorIndex index, Function<RecordSet, RecordSet> probeKeyNormalizer) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.index = Objects.requireNonNull(index, "index is null");
            this.probeKeyNormalizer = Objects.requireNonNull(probeKeyNormalizer, "probeKeyNormalizer is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, IndexSourceOperator.class.getSimpleName());
            return new IndexSourceOperator(operatorContext, this.sourceId, this.index, this.probeKeyNormalizer);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

