/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableList;
import io.trino.operator.CompletedWork;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.Work;
import io.trino.operator.project.InputChannels;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.util.List;

public class ConstantPageProjection
implements PageProjection {
    private static final InputChannels INPUT_PARAMETERS = new InputChannels((List<Integer>)ImmutableList.of());
    private final Type type;
    private final Block value;

    public ConstantPageProjection(Object value, Type type) {
        this.type = type;
        this.value = TypeUtils.writeNativeValue((Type)type, (Object)value);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return INPUT_PARAMETERS;
    }

    @Override
    public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, SourcePage page, SelectedPositions selectedPositions) {
        return new CompletedWork<Block>(RunLengthEncodedBlock.create((Block)this.value, (int)selectedPositions.size()));
    }
}

