/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.BlockSet;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;

@ScalarFunction(value="array_intersect")
@Description(value="Intersects elements of the two given arrays")
public final class ArrayIntersectFunction {
    private final BufferedArrayValueBuilder arrayValueBuilder;

    @TypeParameter(value="E")
    public ArrayIntersectFunction(@TypeParameter(value="E") Type elementType) {
        this.arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)new ArrayType(elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block intersect(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IDENTICAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionIsIdentical elementIdentical, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode elementHashCode, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() < rightArray.getPositionCount()) {
            Block tempArray = leftArray;
            leftArray = rightArray;
            rightArray = tempArray;
        }
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (rightPositionCount == 0) {
            return rightArray;
        }
        BlockSet rightSet = new BlockSet(type, elementIdentical, elementHashCode, rightPositionCount);
        for (int i = 0; i < rightPositionCount; ++i) {
            rightSet.add(rightArray, i);
        }
        BlockSet intersectSet = new BlockSet(type, elementIdentical, elementHashCode, rightSet.size());
        for (int i = 0; i < leftPositionCount; ++i) {
            if (!rightSet.contains(leftArray, i)) continue;
            intersectSet.add(leftArray, i);
        }
        return this.arrayValueBuilder.build(intersectSet.size(), blockBuilder -> intersectSet.getAllWithSizeLimit(blockBuilder, "array_intersect", BlockSet.MAX_FUNCTION_MEMORY));
    }
}

