/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.BlockSet;
import io.trino.spi.block.Block;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;

@ScalarFunction(value="arrays_overlap")
@Description(value="Returns true if arrays have common elements")
public final class ArraysOverlapFunction {
    private ArraysOverlapFunction() {
    }

    @SqlNullable
    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static Boolean arraysOverlap(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IDENTICAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionIsIdentical elementIdentical, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode elementHashCode, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        Block smaller = rightArray;
        Block larger = leftArray;
        if (leftArray.getPositionCount() < rightArray.getPositionCount()) {
            smaller = leftArray;
            larger = rightArray;
        }
        int largerPositionCount = larger.getPositionCount();
        int smallerPositionCount = smaller.getPositionCount();
        if (largerPositionCount == 0 || smallerPositionCount == 0) {
            return false;
        }
        BlockSet smallerSet = new BlockSet(type, elementIdentical, elementHashCode, smallerPositionCount);
        for (int position = 0; position < smallerPositionCount; ++position) {
            smallerSet.add(smaller, position);
        }
        boolean largerContainsNull = false;
        for (int position = 0; position < largerPositionCount; ++position) {
            if (larger.isNull(position)) {
                largerContainsNull = true;
                continue;
            }
            if (!smallerSet.contains(larger, position)) continue;
            return true;
        }
        return largerContainsNull || smallerSet.containsNullElement() ? null : Boolean.valueOf(false);
    }
}

