/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

@Description(value="Last day of the month of the given timestamp")
@ScalarFunction(value="last_day_of_month")
public final class LastDayOfMonth {
    private static final int MILLISECONDS_IN_DAY = 86400000;

    private LastDayOfMonth() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long lastDayOfMonth(@SqlType(value="timestamp(p)") long timestamp) {
        long epochMillis = DateTimes.scaleEpochMicrosToMillis(timestamp);
        long millis = ISOChronology.getInstanceUTC().monthOfYear().roundCeiling(epochMillis + 1L) - 86400000L;
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long lastDayOfMonth(@SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return LastDayOfMonth.lastDayOfMonth(timestamp.getEpochMicros());
    }
}

