/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import io.trino.util.DateTimeZoneIndex;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;

@Description(value="Formats the given time by the given format")
@ScalarFunction(value="format_datetime")
public final class FormatDateTime {
    private FormatDateTime() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="varchar(x)") Slice formatString) {
        ISOChronology chronology = DateTimeZoneIndex.unpackChronology(packedEpochMillis);
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        return FormatDateTime.format(session, epochMillis, chronology, formatString);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        return FormatDateTime.format(session, DateTimes.roundToEpochMillis(timestamp), DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())), formatString);
    }

    private static Slice format(ConnectorSession session, long epochMillis, ISOChronology chronology, Slice formatString) {
        try {
            return Slices.utf8Slice((String)DateTimeFormat.forPattern((String)formatString.toStringUtf8()).withChronology((Chronology)chronology).withLocale(session.getLocale()).print(epochMillis));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }
}

