/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.http.server.HttpsConfig;
import io.airlift.node.AddressToHostname;
import io.airlift.node.NodeConfig;
import io.trino.server.InternalAuthenticationManager;
import io.trino.server.InternalCommunicationConfig;
import io.trino.server.InternalCommunicationHttpClientModule;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

public class InternalCommunicationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        InternalCommunicationConfig internalCommunicationConfig = (InternalCommunicationConfig)this.buildConfigObject(InternalCommunicationConfig.class);
        Multibinder discoveryFilterBinder = Multibinder.newSetBinder((Binder)binder, HttpRequestFilter.class, ForDiscoveryClient.class);
        if (internalCommunicationConfig.isHttpsRequired() && internalCommunicationConfig.getKeyStorePath() == null && internalCommunicationConfig.getTrustStorePath() == null) {
            String sharedSecret = internalCommunicationConfig.getSharedSecret().orElseThrow(() -> new IllegalArgumentException("Internal shared secret must be set when internal HTTPS is enabled"));
            ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpsConfig.class, config -> config.setAutomaticHttpsSharedSecret(sharedSecret));
            ConfigBinder.configBinder((Binder)binder).bindConfigGlobalDefaults(NodeConfig.class, config -> config.setInternalAddressSource(NodeConfig.AddressSource.IP_ENCODED_AS_HOSTNAME));
            discoveryFilterBinder.addBinding().to(DiscoveryEncodeAddressAsHostname.class);
        }
        discoveryFilterBinder.addBinding().to(InternalAuthenticationManager.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpClientConfig.class, ForDiscoveryClient.class, config -> InternalCommunicationHttpClientModule.configureClient(config, internalCommunicationConfig));
        binder.bind(InternalAuthenticationManager.class);
    }

    private static class DiscoveryEncodeAddressAsHostname
    implements HttpRequestFilter {
        private DiscoveryEncodeAddressAsHostname() {
        }

        public Request filterRequest(Request request) {
            return Request.Builder.fromRequest((Request)request).setUri(DiscoveryEncodeAddressAsHostname.toIpEncodedAsHostnameUri(request.getUri())).build();
        }

        private static URI toIpEncodedAsHostnameUri(URI uri) {
            if (!uri.getScheme().equals("https")) {
                return uri;
            }
            try {
                String host = uri.getHost();
                InetAddress inetAddress = InetAddress.getByName(host);
                String addressAsHostname = AddressToHostname.encodeAddressAsHostname((InetAddress)inetAddress);
                return new URI(uri.getScheme(), uri.getUserInfo(), addressAsHostname, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (UnknownHostException e) {
                throw new UncheckedIOException(e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

