/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.cache.CacheUtils;
import io.trino.cache.SafeCaches;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.StringLiteral;
import io.trino.type.DateTimes;
import io.trino.type.JsonType;
import io.trino.util.DateTimeUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class LiteralInterpreter {
    private final PlannerContext plannerContext;
    private final ConnectorSession connectorSession;
    private final InterpretedFunctionInvoker functionInvoker;
    private final Cache<Type, Function<GenericLiteral, Object>> genericLiteralEvaluatorCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));

    public LiteralInterpreter(PlannerContext plannerContext, Session session) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.connectorSession = session.toConnectorSession();
        this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
    }

    public Object evaluate(Literal node, Type type) {
        return new LiteralVisitor(type).process((Node)node, null);
    }

    private class LiteralVisitor
    extends AstVisitor<Object, Void> {
        private final Type type;

        private LiteralVisitor(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        protected Object visitLiteral(Literal node, Void context) {
            throw new UnsupportedOperationException("Unhandled literal type: " + String.valueOf(node));
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Void context) {
            return node.getValue();
        }

        protected Long visitLongLiteral(LongLiteral node, Void context) {
            return node.getParsedValue();
        }

        protected Double visitDoubleLiteral(DoubleLiteral node, Void context) {
            return node.getValue();
        }

        protected Object visitDecimalLiteral(DecimalLiteral node, Void context) {
            return Decimals.parse((String)node.getValue()).getObject();
        }

        protected Slice visitStringLiteral(StringLiteral node, Void context) {
            return Slices.utf8Slice((String)node.getValue());
        }

        protected Slice visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Slices.wrappedBuffer((byte[])node.getValue());
        }

        protected Object visitGenericLiteral(GenericLiteral node, Void context) {
            Type type = this.type;
            Objects.requireNonNull(type);
            Type type2 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeType.class, TimeWithTimeZoneType.class, TimestampType.class, TimestampWithTimeZoneType.class}, (Type)type2, n)) {
                case 0 -> {
                    TimeType unused = (TimeType)type2;
                    yield DateTimes.parseTime(node.getValue());
                }
                case 1 -> {
                    TimeWithTimeZoneType value = (TimeWithTimeZoneType)type2;
                    yield DateTimes.parseTimeWithTimeZone(value.getPrecision(), node.getValue());
                }
                case 2 -> {
                    TimestampType value = (TimestampType)type2;
                    yield DateTimes.parseTimestamp(value.getPrecision(), node.getValue());
                }
                case 3 -> {
                    TimestampWithTimeZoneType value = (TimestampWithTimeZoneType)type2;
                    yield DateTimes.parseTimestampWithTimeZone(value.getPrecision(), node.getValue());
                }
                default -> {
                    Function evaluator = (Function)CacheUtils.uncheckedCacheGet(LiteralInterpreter.this.genericLiteralEvaluatorCache, (Object)this.type, () -> {
                        boolean isJson = JsonType.JSON.equals(this.type);
                        ResolvedFunction resolvedFunction = isJson ? LiteralInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("json_parse", TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR})) : LiteralInterpreter.this.plannerContext.getMetadata().getCoercion((Type)VarcharType.VARCHAR, this.type);
                        return evaluatedNode -> LiteralInterpreter.this.functionInvoker.invoke(resolvedFunction, LiteralInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)evaluatedNode.getValue())));
                    });
                    yield evaluator.apply(node);
                }
            };
        }

        protected Long visitIntervalLiteral(IntervalLiteral node, Void context) {
            if (node.isYearToMonth()) {
                return (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField());
            }
            return (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
        }

        protected Object visitNullLiteral(NullLiteral node, Void context) {
            return null;
        }
    }
}

