/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.List;
import java.util.Objects;

public class AndCodeGenerator
implements BytecodeGenerator {
    private final List<RowExpression> terms;

    public AndCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        Preconditions.checkArgument((specialForm.arguments().size() >= 2 ? 1 : 0) != 0);
        this.terms = specialForm.arguments();
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator) {
        Variable wasNull = generator.wasNull();
        BytecodeBlock block = new BytecodeBlock().comment("AND").setDescription("AND");
        block.push(false);
        LabelNode end = new LabelNode("end");
        LabelNode returnFalse = new LabelNode("returnFalse");
        for (int i = 0; i < this.terms.size(); ++i) {
            RowExpression term = this.terms.get(i);
            block.append(generator.generate(term));
            IfStatement ifWasNull = new IfStatement("if term " + i + " wasNull...", new Object[0]).condition((BytecodeNode)wasNull);
            ifWasNull.ifTrue().comment("clear the null flag, pop residual value off stack, and push was null flag on the stack (true)").pop(term.type().getJavaType()).pop(Boolean.TYPE).push(true);
            ifWasNull.ifFalse().comment("if term is false, short circuit and return false").ifFalseGoto(returnFalse);
            block.append((BytecodeNode)ifWasNull).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        }
        block.putVariable(wasNull).push(true).gotoLabel(end);
        block.visitLabel(returnFalse).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).pop(Boolean.TYPE).push(false);
        block.visitLabel(end);
        return block;
    }
}

