/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import io.trino.sql.ir.Expression;
import java.util.Objects;

public final class NodeRef<T extends Expression> {
    private final T node;

    public static <T extends Expression> NodeRef<T> of(T node) {
        return new NodeRef<T>(node);
    }

    private NodeRef(T node) {
        this.node = (Expression)Objects.requireNonNull(node, "node is null");
    }

    public T getNode() {
        return this.node;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeRef other = (NodeRef)o;
        return this.node == other.node;
    }

    public int hashCode() {
        return System.identityHashCode(this.node);
    }

    public String toString() {
        return "@%s: %s".formatted(Integer.toHexString(System.identityHashCode(this.node)), this.node);
    }
}

